/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class VerifiedAccessTrustProviderCondensedListCopier {
    static List<VerifiedAccessTrustProviderCondensed> copy(
            Collection<? extends VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviderCondensedListParam) {
        List<VerifiedAccessTrustProviderCondensed> list;
        if (verifiedAccessTrustProviderCondensedListParam == null
                || verifiedAccessTrustProviderCondensedListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VerifiedAccessTrustProviderCondensed> modifiableList = new ArrayList<>();
            verifiedAccessTrustProviderCondensedListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VerifiedAccessTrustProviderCondensed> copyFromBuilder(
            Collection<? extends VerifiedAccessTrustProviderCondensed.Builder> verifiedAccessTrustProviderCondensedListParam) {
        List<VerifiedAccessTrustProviderCondensed> list;
        if (verifiedAccessTrustProviderCondensedListParam == null
                || verifiedAccessTrustProviderCondensedListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VerifiedAccessTrustProviderCondensed> modifiableList = new ArrayList<>();
            verifiedAccessTrustProviderCondensedListParam.forEach(entry -> {
                VerifiedAccessTrustProviderCondensed member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VerifiedAccessTrustProviderCondensed.Builder> copyToBuilder(
            Collection<? extends VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviderCondensedListParam) {
        List<VerifiedAccessTrustProviderCondensed.Builder> list;
        if (verifiedAccessTrustProviderCondensedListParam == null
                || verifiedAccessTrustProviderCondensedListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VerifiedAccessTrustProviderCondensed.Builder> modifiableList = new ArrayList<>();
            verifiedAccessTrustProviderCondensedListParam.forEach(entry -> {
                VerifiedAccessTrustProviderCondensed.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
