/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTransitGatewayVpcAttachmentsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeTransitGatewayVpcAttachmentsRequest.Builder, DescribeTransitGatewayVpcAttachmentsRequest> {
    private static final SdkField<List<String>> TRANSIT_GATEWAY_ATTACHMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayAttachmentIds")
            .getter(getter(DescribeTransitGatewayVpcAttachmentsRequest::transitGatewayAttachmentIds))
            .setter(setter(Builder::transitGatewayAttachmentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentIds")
                    .unmarshallLocationName("TransitGatewayAttachmentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeTransitGatewayVpcAttachmentsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeTransitGatewayVpcAttachmentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeTransitGatewayVpcAttachmentsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_IDS_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> transitGatewayAttachmentIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeTransitGatewayVpcAttachmentsRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentIds = builder.transitGatewayAttachmentIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransitGatewayAttachmentIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransitGatewayAttachmentIds() {
        return transitGatewayAttachmentIds != null && !(transitGatewayAttachmentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitGatewayAttachmentIds} method.
     * </p>
     * 
     * @return The IDs of the attachments.
     */
    public final List<String> transitGatewayAttachmentIds() {
        return transitGatewayAttachmentIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>state</code> - The state of the attachment. Valid values are <code>available</code> | <code>deleted</code>
     * | <code>deleting</code> | <code>failed</code> | <code>failing</code> | <code>initiatingRequest</code> |
     * <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> |
     * <code>rejected</code> | <code>rejecting</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-attachment-id</code> - The ID of the attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-id</code> - The ID of the transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the attachment. Valid values are <code>available</code> |
     *         <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> |
     *         <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> |
     *         <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-attachment-id</code> - The ID of the attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-id</code> - The ID of the transit gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayAttachmentIds() ? transitGatewayAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayVpcAttachmentsRequest)) {
            return false;
        }
        DescribeTransitGatewayVpcAttachmentsRequest other = (DescribeTransitGatewayVpcAttachmentsRequest) obj;
        return hasTransitGatewayAttachmentIds() == other.hasTransitGatewayAttachmentIds()
                && Objects.equals(transitGatewayAttachmentIds(), other.transitGatewayAttachmentIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTransitGatewayVpcAttachmentsRequest")
                .add("TransitGatewayAttachmentIds", hasTransitGatewayAttachmentIds() ? transitGatewayAttachmentIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentIds":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayVpcAttachmentsRequest, T> g) {
        return obj -> g.apply((DescribeTransitGatewayVpcAttachmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTransitGatewayVpcAttachmentsRequest> {
        /**
         * <p>
         * The IDs of the attachments.
         * </p>
         * 
         * @param transitGatewayAttachmentIds
         *        The IDs of the attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentIds(Collection<String> transitGatewayAttachmentIds);

        /**
         * <p>
         * The IDs of the attachments.
         * </p>
         * 
         * @param transitGatewayAttachmentIds
         *        The IDs of the attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentIds(String... transitGatewayAttachmentIds);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>state</code> - The state of the attachment. Valid values are <code>available</code> |
         * <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> |
         * <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> |
         * <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-attachment-id</code> - The ID of the attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of the transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the attachment. Valid values are <code>available</code> |
         *        <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> |
         *        <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> |
         *        <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-attachment-id</code> - The ID of the attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-id</code> - The ID of the transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>state</code> - The state of the attachment. Valid values are <code>available</code> |
         * <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> |
         * <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> |
         * <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-attachment-id</code> - The ID of the attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of the transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the attachment. Valid values are <code>available</code> |
         *        <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> |
         *        <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> |
         *        <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-attachment-id</code> - The ID of the attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-id</code> - The ID of the transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>state</code> - The state of the attachment. Valid values are <code>available</code> |
         * <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> |
         * <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> |
         * <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-attachment-id</code> - The ID of the attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-id</code> - The ID of the transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> transitGatewayAttachmentIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayVpcAttachmentsRequest model) {
            super(model);
            transitGatewayAttachmentIds(model.transitGatewayAttachmentIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTransitGatewayAttachmentIds() {
            if (transitGatewayAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return transitGatewayAttachmentIds;
        }

        public final void setTransitGatewayAttachmentIds(Collection<String> transitGatewayAttachmentIds) {
            this.transitGatewayAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(transitGatewayAttachmentIds);
        }

        @Override
        public final Builder transitGatewayAttachmentIds(Collection<String> transitGatewayAttachmentIds) {
            this.transitGatewayAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(transitGatewayAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayAttachmentIds(String... transitGatewayAttachmentIds) {
            transitGatewayAttachmentIds(Arrays.asList(transitGatewayAttachmentIds));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTransitGatewayVpcAttachmentsRequest build() {
            return new DescribeTransitGatewayVpcAttachmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
