/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSubnetCidrReservationRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteSubnetCidrReservationRequest.Builder, DeleteSubnetCidrReservationRequest> {
    private static final SdkField<String> SUBNET_CIDR_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetCidrReservationId")
            .getter(getter(DeleteSubnetCidrReservationRequest::subnetCidrReservationId))
            .setter(setter(Builder::subnetCidrReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetCidrReservationId")
                    .unmarshallLocationName("SubnetCidrReservationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUBNET_CIDR_RESERVATION_ID_FIELD));

    private final String subnetCidrReservationId;

    private DeleteSubnetCidrReservationRequest(BuilderImpl builder) {
        super(builder);
        this.subnetCidrReservationId = builder.subnetCidrReservationId;
    }

    /**
     * <p>
     * The ID of the subnet CIDR reservation.
     * </p>
     * 
     * @return The ID of the subnet CIDR reservation.
     */
    public final String subnetCidrReservationId() {
        return subnetCidrReservationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetCidrReservationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubnetCidrReservationRequest)) {
            return false;
        }
        DeleteSubnetCidrReservationRequest other = (DeleteSubnetCidrReservationRequest) obj;
        return Objects.equals(subnetCidrReservationId(), other.subnetCidrReservationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSubnetCidrReservationRequest").add("SubnetCidrReservationId", subnetCidrReservationId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetCidrReservationId":
            return Optional.ofNullable(clazz.cast(subnetCidrReservationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSubnetCidrReservationRequest, T> g) {
        return obj -> g.apply((DeleteSubnetCidrReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSubnetCidrReservationRequest> {
        /**
         * <p>
         * The ID of the subnet CIDR reservation.
         * </p>
         * 
         * @param subnetCidrReservationId
         *        The ID of the subnet CIDR reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetCidrReservationId(String subnetCidrReservationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String subnetCidrReservationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubnetCidrReservationRequest model) {
            super(model);
            subnetCidrReservationId(model.subnetCidrReservationId);
        }

        public final String getSubnetCidrReservationId() {
            return subnetCidrReservationId;
        }

        public final void setSubnetCidrReservationId(String subnetCidrReservationId) {
            this.subnetCidrReservationId = subnetCidrReservationId;
        }

        @Override
        public final Builder subnetCidrReservationId(String subnetCidrReservationId) {
            this.subnetCidrReservationId = subnetCidrReservationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSubnetCidrReservationRequest build() {
            return new DeleteSubnetCidrReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
