/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessScopePath implements SdkPojo, Serializable, ToCopyableBuilder<AccessScopePath.Builder, AccessScopePath> {
    private static final SdkField<PathStatement> SOURCE_FIELD = SdkField
            .<PathStatement> builder(MarshallingType.SDK_POJO)
            .memberName("Source")
            .getter(getter(AccessScopePath::source))
            .setter(setter(Builder::source))
            .constructor(PathStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("source").build()).build();

    private static final SdkField<PathStatement> DESTINATION_FIELD = SdkField
            .<PathStatement> builder(MarshallingType.SDK_POJO)
            .memberName("Destination")
            .getter(getter(AccessScopePath::destination))
            .setter(setter(Builder::destination))
            .constructor(PathStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("destination").build()).build();

    private static final SdkField<List<ThroughResourcesStatement>> THROUGH_RESOURCES_FIELD = SdkField
            .<List<ThroughResourcesStatement>> builder(MarshallingType.LIST)
            .memberName("ThroughResources")
            .getter(getter(AccessScopePath::throughResources))
            .setter(setter(Builder::throughResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughResourceSet")
                    .unmarshallLocationName("throughResourceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ThroughResourcesStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThroughResourcesStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, THROUGH_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final PathStatement source;

    private final PathStatement destination;

    private final List<ThroughResourcesStatement> throughResources;

    private AccessScopePath(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.throughResources = builder.throughResources;
    }

    /**
     * <p>
     * The source.
     * </p>
     * 
     * @return The source.
     */
    public final PathStatement source() {
        return source;
    }

    /**
     * <p>
     * The destination.
     * </p>
     * 
     * @return The destination.
     */
    public final PathStatement destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThroughResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThroughResources() {
        return throughResources != null && !(throughResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The through resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThroughResources} method.
     * </p>
     * 
     * @return The through resources.
     */
    public final List<ThroughResourcesStatement> throughResources() {
        return throughResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(hasThroughResources() ? throughResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScopePath)) {
            return false;
        }
        AccessScopePath other = (AccessScopePath) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && hasThroughResources() == other.hasThroughResources()
                && Objects.equals(throughResources(), other.throughResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessScopePath").add("Source", source()).add("Destination", destination())
                .add("ThroughResources", hasThroughResources() ? throughResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "ThroughResources":
            return Optional.ofNullable(clazz.cast(throughResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessScopePath, T> g) {
        return obj -> g.apply((AccessScopePath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessScopePath> {
        /**
         * <p>
         * The source.
         * </p>
         * 
         * @param source
         *        The source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(PathStatement source);

        /**
         * <p>
         * The source.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathStatement.Builder} avoiding the need
         * to create one manually via {@link PathStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #source(PathStatement)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link PathStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(PathStatement)
         */
        default Builder source(Consumer<PathStatement.Builder> source) {
            return source(PathStatement.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The destination.
         * </p>
         * 
         * @param destination
         *        The destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(PathStatement destination);

        /**
         * <p>
         * The destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathStatement.Builder} avoiding the need
         * to create one manually via {@link PathStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(PathStatement)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link PathStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(PathStatement)
         */
        default Builder destination(Consumer<PathStatement.Builder> destination) {
            return destination(PathStatement.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The through resources.
         * </p>
         * 
         * @param throughResources
         *        The through resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughResources(Collection<ThroughResourcesStatement> throughResources);

        /**
         * <p>
         * The through resources.
         * </p>
         * 
         * @param throughResources
         *        The through resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughResources(ThroughResourcesStatement... throughResources);

        /**
         * <p>
         * The through resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement.Builder#build()} is called
         * immediately and its result is passed to {@link #throughResources(List<ThroughResourcesStatement>)}.
         * 
         * @param throughResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throughResources(java.util.Collection<ThroughResourcesStatement>)
         */
        Builder throughResources(Consumer<ThroughResourcesStatement.Builder>... throughResources);
    }

    static final class BuilderImpl implements Builder {
        private PathStatement source;

        private PathStatement destination;

        private List<ThroughResourcesStatement> throughResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessScopePath model) {
            source(model.source);
            destination(model.destination);
            throughResources(model.throughResources);
        }

        public final PathStatement.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(PathStatement.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(PathStatement source) {
            this.source = source;
            return this;
        }

        public final PathStatement.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(PathStatement.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(PathStatement destination) {
            this.destination = destination;
            return this;
        }

        public final List<ThroughResourcesStatement.Builder> getThroughResources() {
            List<ThroughResourcesStatement.Builder> result = ThroughResourcesStatementListCopier
                    .copyToBuilder(this.throughResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThroughResources(Collection<ThroughResourcesStatement.BuilderImpl> throughResources) {
            this.throughResources = ThroughResourcesStatementListCopier.copyFromBuilder(throughResources);
        }

        @Override
        public final Builder throughResources(Collection<ThroughResourcesStatement> throughResources) {
            this.throughResources = ThroughResourcesStatementListCopier.copy(throughResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughResources(ThroughResourcesStatement... throughResources) {
            throughResources(Arrays.asList(throughResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughResources(Consumer<ThroughResourcesStatement.Builder>... throughResources) {
            throughResources(Stream.of(throughResources).map(c -> ThroughResourcesStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AccessScopePath build() {
            return new AccessScopePath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
