/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ebs.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.ebs.model.EbsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSnapshotBlockRequest
extends EbsRequest
implements ToCopyableBuilder<Builder, PutSnapshotBlockRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(PutSnapshotBlockRequest.getter(PutSnapshotBlockRequest::snapshotId)).setter(PutSnapshotBlockRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()}).build();
    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockIndex").getter(PutSnapshotBlockRequest.getter(PutSnapshotBlockRequest::blockIndex)).setter(PutSnapshotBlockRequest.setter(Builder::blockIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("blockIndex").build()}).build();
    private static final SdkField<Integer> DATA_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataLength").getter(PutSnapshotBlockRequest.getter(PutSnapshotBlockRequest::dataLength)).setter(PutSnapshotBlockRequest.setter(Builder::dataLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Data-Length").build()}).build();
    private static final SdkField<Integer> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Progress").getter(PutSnapshotBlockRequest.getter(PutSnapshotBlockRequest::progress)).setter(PutSnapshotBlockRequest.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Progress").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(PutSnapshotBlockRequest.getter(PutSnapshotBlockRequest::checksum)).setter(PutSnapshotBlockRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(PutSnapshotBlockRequest.getter(PutSnapshotBlockRequest::checksumAlgorithmAsString)).setter(PutSnapshotBlockRequest.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum-Algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, BLOCK_INDEX_FIELD, DATA_LENGTH_FIELD, PROGRESS_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD));
    private final String snapshotId;
    private final Integer blockIndex;
    private final Integer dataLength;
    private final Integer progress;
    private final String checksum;
    private final String checksumAlgorithm;

    private PutSnapshotBlockRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.blockIndex = builder.blockIndex;
        this.dataLength = builder.dataLength;
        this.progress = builder.progress;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Integer blockIndex() {
        return this.blockIndex;
    }

    public final Integer dataLength() {
        return this.dataLength;
    }

    public final Integer progress() {
        return this.progress;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final ChecksumAlgorithm checksumAlgorithm() {
        return ChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSnapshotBlockRequest)) {
            return false;
        }
        PutSnapshotBlockRequest other = (PutSnapshotBlockRequest)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.blockIndex(), other.blockIndex()) && Objects.equals(this.dataLength(), other.dataLength()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutSnapshotBlockRequest").add("SnapshotId", (Object)this.snapshotId()).add("BlockIndex", (Object)this.blockIndex()).add("DataLength", (Object)this.dataLength()).add("Progress", (Object)this.progress()).add("Checksum", (Object)this.checksum()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "BlockIndex": {
                return Optional.ofNullable(clazz.cast(this.blockIndex()));
            }
            case "DataLength": {
                return Optional.ofNullable(clazz.cast(this.dataLength()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSnapshotBlockRequest, T> g) {
        return obj -> g.apply((PutSnapshotBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsRequest.BuilderImpl
    implements Builder {
        private String snapshotId;
        private Integer blockIndex;
        private Integer dataLength;
        private Integer progress;
        private String checksum;
        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSnapshotBlockRequest model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.blockIndex(model.blockIndex);
            this.dataLength(model.dataLength);
            this.progress(model.progress);
            this.checksum(model.checksum);
            this.checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getBlockIndex() {
            return this.blockIndex;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        @Override
        @Transient
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final Integer getDataLength() {
            return this.dataLength;
        }

        public final void setDataLength(Integer dataLength) {
            this.dataLength = dataLength;
        }

        @Override
        @Transient
        public final Builder dataLength(Integer dataLength) {
            this.dataLength = dataLength;
            return this;
        }

        public final Integer getProgress() {
            return this.progress;
        }

        public final void setProgress(Integer progress) {
            this.progress = progress;
        }

        @Override
        @Transient
        public final Builder progress(Integer progress) {
            this.progress = progress;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        @Transient
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        @Transient
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        @Transient
        public final Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSnapshotBlockRequest build() {
            return new PutSnapshotBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSnapshotBlockRequest> {
        public Builder snapshotId(String var1);

        public Builder blockIndex(Integer var1);

        public Builder dataLength(Integer var1);

        public Builder progress(Integer var1);

        public Builder checksum(String var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(ChecksumAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

