/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.ThrottlingReason;
import software.amazon.awssdk.services.dynamodb.model.ThrottlingReasonListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedThroughputExceededException
extends DynamoDbException
implements ToCopyableBuilder<Builder, ProvisionedThroughputExceededException> {
    private static final SdkField<List<ThrottlingReason>> THROTTLING_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThrottlingReasons").getter(ProvisionedThroughputExceededException.getter(ProvisionedThroughputExceededException::throttlingReasons)).setter(ProvisionedThroughputExceededException.setter(Builder::throttlingReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottlingReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThrottlingReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROTTLING_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisionedThroughputExceededException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ThrottlingReason> throttlingReasons;

    private ProvisionedThroughputExceededException(BuilderImpl builder) {
        super(builder);
        this.throttlingReasons = builder.throttlingReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasThrottlingReasons() {
        return this.throttlingReasons != null && !(this.throttlingReasons instanceof SdkAutoConstructList);
    }

    public List<ThrottlingReason> throttlingReasons() {
        return this.throttlingReasons;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ThrottlingReason>>> map = new HashMap<String, SdkField<List<ThrottlingReason>>>();
        map.put("ThrottlingReasons", THROTTLING_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughputExceededException, T> g) {
        return obj -> g.apply((ProvisionedThroughputExceededException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbException.BuilderImpl
    implements Builder {
        private List<ThrottlingReason> throttlingReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputExceededException model) {
            super(model);
            this.throttlingReasons(model.throttlingReasons);
        }

        public final List<ThrottlingReason.Builder> getThrottlingReasons() {
            List<ThrottlingReason.Builder> result = ThrottlingReasonListCopier.copyToBuilder(this.throttlingReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThrottlingReasons(Collection<ThrottlingReason.BuilderImpl> throttlingReasons) {
            this.throttlingReasons = ThrottlingReasonListCopier.copyFromBuilder(throttlingReasons);
        }

        @Override
        public final Builder throttlingReasons(Collection<ThrottlingReason> throttlingReasons) {
            this.throttlingReasons = ThrottlingReasonListCopier.copy(throttlingReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throttlingReasons(ThrottlingReason ... throttlingReasons) {
            this.throttlingReasons(Arrays.asList(throttlingReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throttlingReasons(Consumer<ThrottlingReason.Builder> ... throttlingReasons) {
            this.throttlingReasons(Stream.of(throttlingReasons).map(c -> (ThrottlingReason)((ThrottlingReason.Builder)ThrottlingReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ProvisionedThroughputExceededException build() {
            return new ProvisionedThroughputExceededException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedThroughputExceededException>,
    DynamoDbException.Builder {
        public Builder throttlingReasons(Collection<ThrottlingReason> var1);

        public Builder throttlingReasons(ThrottlingReason ... var1);

        public Builder throttlingReasons(Consumer<ThrottlingReason.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

