/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ExecuteStatementResponse> {
    private static final SdkField<List<Map<String, AttributeValue>>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::items)).setter(ExecuteStatementResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::nextToken)).setter(ExecuteStatementResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumedCapacity").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::consumedCapacity)).setter(ExecuteStatementResponse.setter(Builder::consumedCapacity)).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> LAST_EVALUATED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LastEvaluatedKey").getter(ExecuteStatementResponse.getter(ExecuteStatementResponse::lastEvaluatedKey)).setter(ExecuteStatementResponse.setter(Builder::lastEvaluatedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedKey").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD, CONSUMED_CAPACITY_FIELD, LAST_EVALUATED_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteStatementResponse.memberNameToFieldInitializer();
    private final List<Map<String, AttributeValue>> items;
    private final String nextToken;
    private final ConsumedCapacity consumedCapacity;
    private final Map<String, AttributeValue> lastEvaluatedKey;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
        this.consumedCapacity = builder.consumedCapacity;
        this.lastEvaluatedKey = builder.lastEvaluatedKey;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<Map<String, AttributeValue>> items() {
        return this.items;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public final boolean hasLastEvaluatedKey() {
        return this.lastEvaluatedKey != null && !(this.lastEvaluatedKey instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> lastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastEvaluatedKey() ? this.lastEvaluatedKey() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && this.hasLastEvaluatedKey() == other.hasLastEvaluatedKey() && Objects.equals(this.lastEvaluatedKey(), other.lastEvaluatedKey());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteStatementResponse").add("Items", this.hasItems() ? this.items() : null).add("NextToken", (Object)this.nextToken()).add("ConsumedCapacity", (Object)this.consumedCapacity()).add("LastEvaluatedKey", this.hasLastEvaluatedKey() ? this.lastEvaluatedKey() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "LastEvaluatedKey": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Items", ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
        map.put("LastEvaluatedKey", LAST_EVALUATED_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<Map<String, AttributeValue>> items = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private ConsumedCapacity consumedCapacity;
        private Map<String, AttributeValue> lastEvaluatedKey = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            this.items(model.items);
            this.nextToken(model.nextToken);
            this.consumedCapacity(model.consumedCapacity);
            this.lastEvaluatedKey(model.lastEvaluatedKey);
        }

        public final List<Map<String, AttributeValue.Builder>> getItems() {
            List<Map<String, AttributeValue.Builder>> result = ItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<? extends Map<String, AttributeValue.BuilderImpl>> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<? extends Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue> ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return this.consumedCapacity != null ? this.consumedCapacity.toBuilder() : null;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getLastEvaluatedKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.lastEvaluatedKey);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLastEvaluatedKey(Map<String, AttributeValue.BuilderImpl> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copyFromBuilder(lastEvaluatedKey);
        }

        @Override
        public final Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
            return this;
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementResponse> {
        public Builder items(Collection<? extends Map<String, AttributeValue>> var1);

        public Builder items(Map<String, AttributeValue> ... var1);

        public Builder nextToken(String var1);

        public Builder consumedCapacity(ConsumedCapacity var1);

        default public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return this.consumedCapacity((ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation(consumedCapacity)).build());
        }

        public Builder lastEvaluatedKey(Map<String, AttributeValue> var1);
    }
}

