/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.DynamoDbStreamsEndpointParams;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.DynamoDbStreamsEndpointProvider;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultDynamoDbStreamsEndpointProvider
implements DynamoDbStreamsEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(DynamoDbStreamsEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(DynamoDbStreamsEndpointParams params, LocalState locals) {
        RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultDynamoDbStreamsEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultDynamoDbStreamsEndpointProvider.endpointRule27(params, locals);
    }

    private static RuleResult endpointRule1(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(DynamoDbStreamsEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule24(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbStreamsEndpointProvider.endpointRule25(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule9(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule10(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule11(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule14(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule15(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule16(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbStreamsEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule19(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultDynamoDbStreamsEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule19(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule20(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("local".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("http://localhost:8000")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("dynamodb").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("aws-cn".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + ".amazonaws.com.cn")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("aws-iso".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + ".c2s.ic.gov")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(DynamoDbStreamsEndpointParams params, LocalState locals) {
        if ("aws-iso-b".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + ".sc2s.sgov.gov")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://streams.dynamodb." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule27(DynamoDbStreamsEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

