/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueListCopier;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpectedAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpectedAttributeValue> {
    private static final SdkField<AttributeValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(ExpectedAttributeValue.getter(ExpectedAttributeValue::value)).setter(ExpectedAttributeValue.setter(Builder::value)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Boolean> EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exists").getter(ExpectedAttributeValue.getter(ExpectedAttributeValue::exists)).setter(ExpectedAttributeValue.setter(Builder::exists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exists").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(ExpectedAttributeValue.getter(ExpectedAttributeValue::comparisonOperatorAsString)).setter(ExpectedAttributeValue.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<List<AttributeValue>> ATTRIBUTE_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeValueList").getter(ExpectedAttributeValue.getter(ExpectedAttributeValue::attributeValueList)).setter(ExpectedAttributeValue.setter(Builder::attributeValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, EXISTS_FIELD, COMPARISON_OPERATOR_FIELD, ATTRIBUTE_VALUE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpectedAttributeValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AttributeValue value;
    private final Boolean exists;
    private final String comparisonOperator;
    private final List<AttributeValue> attributeValueList;

    private ExpectedAttributeValue(BuilderImpl builder) {
        this.value = builder.value;
        this.exists = builder.exists;
        this.comparisonOperator = builder.comparisonOperator;
        this.attributeValueList = builder.attributeValueList;
    }

    public final AttributeValue value() {
        return this.value;
    }

    public final Boolean exists() {
        return this.exists;
    }

    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final boolean hasAttributeValueList() {
        return this.attributeValueList != null && !(this.attributeValueList instanceof SdkAutoConstructList);
    }

    public final List<AttributeValue> attributeValueList() {
        return this.attributeValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.exists());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValueList() ? this.attributeValueList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedAttributeValue)) {
            return false;
        }
        ExpectedAttributeValue other = (ExpectedAttributeValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.exists(), other.exists()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && this.hasAttributeValueList() == other.hasAttributeValueList() && Objects.equals(this.attributeValueList(), other.attributeValueList());
    }

    public final String toString() {
        return ToString.builder((String)"ExpectedAttributeValue").add("Value", (Object)this.value()).add("Exists", (Object)this.exists()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("AttributeValueList", this.hasAttributeValueList() ? this.attributeValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Exists": {
                return Optional.ofNullable(clazz.cast(this.exists()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "AttributeValueList": {
                return Optional.ofNullable(clazz.cast(this.attributeValueList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Exists", EXISTS_FIELD);
        map.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        map.put("AttributeValueList", ATTRIBUTE_VALUE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpectedAttributeValue, T> g) {
        return obj -> g.apply((ExpectedAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeValue value;
        private Boolean exists;
        private String comparisonOperator;
        private List<AttributeValue> attributeValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedAttributeValue model) {
            this.value(model.value);
            this.exists(model.exists);
            this.comparisonOperator(model.comparisonOperator);
            this.attributeValueList(model.attributeValueList);
        }

        public final AttributeValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(AttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(AttributeValue value) {
            this.value = value;
            return this;
        }

        public final Boolean getExists() {
            return this.exists;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final List<AttributeValue.Builder> getAttributeValueList() {
            List<AttributeValue.Builder> result = AttributeValueListCopier.copyToBuilder(this.attributeValueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeValueList(Collection<AttributeValue.BuilderImpl> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copyFromBuilder(attributeValueList);
        }

        @Override
        public final Builder attributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValueList(AttributeValue ... attributeValueList) {
            this.attributeValueList(Arrays.asList(attributeValueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValueList(Consumer<AttributeValue.Builder> ... attributeValueList) {
            this.attributeValueList(Stream.of(attributeValueList).map(c -> (AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExpectedAttributeValue build() {
            return new ExpectedAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpectedAttributeValue> {
        public Builder value(AttributeValue var1);

        default public Builder value(Consumer<AttributeValue.Builder> value) {
            return this.value((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(value)).build());
        }

        public Builder exists(Boolean var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder attributeValueList(Collection<AttributeValue> var1);

        public Builder attributeValueList(AttributeValue ... var1);

        public Builder attributeValueList(Consumer<AttributeValue.Builder> ... var1);
    }
}

