/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SSEType {
    AES256("AES256"),
    KMS("KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SSEType> VALUE_MAP;
    private final String value;

    private SSEType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SSEType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SSEType> knownValues() {
        EnumSet<SSEType> knownValues = EnumSet.allOf(SSEType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SSEType.class, SSEType::toString);
    }
}

