/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The format options for the data that was imported into the target table. There is one value, CsvOption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputFormatOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<InputFormatOptions.Builder, InputFormatOptions> {
    private static final SdkField<CsvOptions> CSV_FIELD = SdkField.<CsvOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Csv").getter(getter(InputFormatOptions::csv)).setter(setter(Builder::csv))
            .constructor(CsvOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csv").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CsvOptions csv;

    private InputFormatOptions(BuilderImpl builder) {
        this.csv = builder.csv;
    }

    /**
     * <p>
     * The options for imported source files in CSV format. The values are Delimiter and HeaderList.
     * </p>
     * 
     * @return The options for imported source files in CSV format. The values are Delimiter and HeaderList.
     */
    public final CsvOptions csv() {
        return csv;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csv());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFormatOptions)) {
            return false;
        }
        InputFormatOptions other = (InputFormatOptions) obj;
        return Objects.equals(csv(), other.csv());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputFormatOptions").add("Csv", csv()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Csv":
            return Optional.ofNullable(clazz.cast(csv()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Csv", CSV_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputFormatOptions, T> g) {
        return obj -> g.apply((InputFormatOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputFormatOptions> {
        /**
         * <p>
         * The options for imported source files in CSV format. The values are Delimiter and HeaderList.
         * </p>
         * 
         * @param csv
         *        The options for imported source files in CSV format. The values are Delimiter and HeaderList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csv(CsvOptions csv);

        /**
         * <p>
         * The options for imported source files in CSV format. The values are Delimiter and HeaderList.
         * </p>
         * This is a convenience method that creates an instance of the {@link CsvOptions.Builder} avoiding the need to
         * create one manually via {@link CsvOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CsvOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #csv(CsvOptions)}.
         * 
         * @param csv
         *        a consumer that will call methods on {@link CsvOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csv(CsvOptions)
         */
        default Builder csv(Consumer<CsvOptions.Builder> csv) {
            return csv(CsvOptions.builder().applyMutation(csv).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CsvOptions csv;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFormatOptions model) {
            csv(model.csv);
        }

        public final CsvOptions.Builder getCsv() {
            return csv != null ? csv.toBuilder() : null;
        }

        public final void setCsv(CsvOptions.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public final Builder csv(CsvOptions csv) {
            this.csv = csv;
            return this;
        }

        @Override
        public InputFormatOptions build() {
            return new InputFormatOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
