/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableKinesisStreamingDestinationResponse extends DynamoDbResponse implements
        ToCopyableBuilder<EnableKinesisStreamingDestinationResponse.Builder, EnableKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(EnableKinesisStreamingDestinationResponse::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(EnableKinesisStreamingDestinationResponse::streamArn))
            .setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatus").getter(getter(EnableKinesisStreamingDestinationResponse::destinationStatusAsString))
            .setter(setter(Builder::destinationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()).build();

    private static final SdkField<EnableKinesisStreamingConfiguration> ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD = SdkField
            .<EnableKinesisStreamingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EnableKinesisStreamingConfiguration")
            .getter(getter(EnableKinesisStreamingDestinationResponse::enableKinesisStreamingConfiguration))
            .setter(setter(Builder::enableKinesisStreamingConfiguration))
            .constructor(EnableKinesisStreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableKinesisStreamingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            STREAM_ARN_FIELD, DESTINATION_STATUS_FIELD, ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tableName;

    private final String streamArn;

    private final String destinationStatus;

    private final EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration;

    private EnableKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
        this.enableKinesisStreamingConfiguration = builder.enableKinesisStreamingConfiguration;
    }

    /**
     * <p>
     * The name of the table being modified.
     * </p>
     * 
     * @return The name of the table being modified.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The ARN for the specific Kinesis data stream.
     * </p>
     * 
     * @return The ARN for the specific Kinesis data stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The current status of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of the replication.
     * @see DestinationStatus
     */
    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(destinationStatus);
    }

    /**
     * <p>
     * The current status of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of the replication.
     * @see DestinationStatus
     */
    public final String destinationStatusAsString() {
        return destinationStatus;
    }

    /**
     * <p>
     * The destination for the Kinesis streaming information that is being enabled.
     * </p>
     * 
     * @return The destination for the Kinesis streaming information that is being enabled.
     */
    public final EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration() {
        return enableKinesisStreamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableKinesisStreamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableKinesisStreamingDestinationResponse)) {
            return false;
        }
        EnableKinesisStreamingDestinationResponse other = (EnableKinesisStreamingDestinationResponse) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(destinationStatusAsString(), other.destinationStatusAsString())
                && Objects.equals(enableKinesisStreamingConfiguration(), other.enableKinesisStreamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableKinesisStreamingDestinationResponse").add("TableName", tableName())
                .add("StreamArn", streamArn()).add("DestinationStatus", destinationStatusAsString())
                .add("EnableKinesisStreamingConfiguration", enableKinesisStreamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "DestinationStatus":
            return Optional.ofNullable(clazz.cast(destinationStatusAsString()));
        case "EnableKinesisStreamingConfiguration":
            return Optional.ofNullable(clazz.cast(enableKinesisStreamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("StreamArn", STREAM_ARN_FIELD);
        map.put("DestinationStatus", DESTINATION_STATUS_FIELD);
        map.put("EnableKinesisStreamingConfiguration", ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((EnableKinesisStreamingDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableKinesisStreamingDestinationResponse> {
        /**
         * <p>
         * The name of the table being modified.
         * </p>
         * 
         * @param tableName
         *        The name of the table being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The ARN for the specific Kinesis data stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN for the specific Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The current status of the replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of the replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(String destinationStatus);

        /**
         * <p>
         * The current status of the replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of the replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(DestinationStatus destinationStatus);

        /**
         * <p>
         * The destination for the Kinesis streaming information that is being enabled.
         * </p>
         * 
         * @param enableKinesisStreamingConfiguration
         *        The destination for the Kinesis streaming information that is being enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration);

        /**
         * <p>
         * The destination for the Kinesis streaming information that is being enabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnableKinesisStreamingConfiguration.Builder} avoiding the need to create one manually via
         * {@link EnableKinesisStreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnableKinesisStreamingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration)}.
         * 
         * @param enableKinesisStreamingConfiguration
         *        a consumer that will call methods on {@link EnableKinesisStreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration)
         */
        default Builder enableKinesisStreamingConfiguration(
                Consumer<EnableKinesisStreamingConfiguration.Builder> enableKinesisStreamingConfiguration) {
            return enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration.builder()
                    .applyMutation(enableKinesisStreamingConfiguration).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String tableName;

        private String streamArn;

        private String destinationStatus;

        private EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableKinesisStreamingDestinationResponse model) {
            super(model);
            tableName(model.tableName);
            streamArn(model.streamArn);
            destinationStatus(model.destinationStatus);
            enableKinesisStreamingConfiguration(model.enableKinesisStreamingConfiguration);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        public final EnableKinesisStreamingConfiguration.Builder getEnableKinesisStreamingConfiguration() {
            return enableKinesisStreamingConfiguration != null ? enableKinesisStreamingConfiguration.toBuilder() : null;
        }

        public final void setEnableKinesisStreamingConfiguration(
                EnableKinesisStreamingConfiguration.BuilderImpl enableKinesisStreamingConfiguration) {
            this.enableKinesisStreamingConfiguration = enableKinesisStreamingConfiguration != null ? enableKinesisStreamingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder enableKinesisStreamingConfiguration(
                EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration) {
            this.enableKinesisStreamingConfiguration = enableKinesisStreamingConfiguration;
            return this;
        }

        @Override
        public EnableKinesisStreamingDestinationResponse build() {
            return new EnableKinesisStreamingDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
