/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStatementResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchStatementResponse> {
    private static final SdkField<BatchStatementError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(BatchStatementResponse.getter(BatchStatementResponse::error)).setter(BatchStatementResponse.setter(Builder::error)).constructor(BatchStatementError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(BatchStatementResponse.getter(BatchStatementResponse::tableName)).setter(BatchStatementResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Item").getter(BatchStatementResponse.getter(BatchStatementResponse::item)).setter(BatchStatementResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, TABLE_NAME_FIELD, ITEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Error", ERROR_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("Item", ITEM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BatchStatementError error;
    private final String tableName;
    private final Map<String, AttributeValue> item;

    private BatchStatementResponse(BuilderImpl builder) {
        this.error = builder.error;
        this.tableName = builder.tableName;
        this.item = builder.item;
    }

    public final BatchStatementError error() {
        return this.error;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStatementResponse)) {
            return false;
        }
        BatchStatementResponse other = (BatchStatementResponse)obj;
        return Objects.equals(this.error(), other.error()) && Objects.equals(this.tableName(), other.tableName()) && this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStatementResponse").add("Error", (Object)this.error()).add("TableName", (Object)this.tableName()).add("Item", this.hasItem() ? this.item() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchStatementResponse, T> g) {
        return obj -> g.apply((BatchStatementResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchStatementError error;
        private String tableName;
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStatementResponse model) {
            this.error(model.error);
            this.tableName(model.tableName);
            this.item(model.item);
        }

        public final BatchStatementError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(BatchStatementError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(BatchStatementError error) {
            this.error = error;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            Map<String, AttributeValue.Builder> result = AttributeMapCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = AttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
            return this;
        }

        public BatchStatementResponse build() {
            return new BatchStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchStatementResponse> {
        public Builder error(BatchStatementError var1);

        default public Builder error(Consumer<BatchStatementError.Builder> error) {
            return this.error((BatchStatementError)((BatchStatementError.Builder)BatchStatementError.builder().applyMutation(error)).build());
        }

        public Builder tableName(String var1);

        public Builder item(Map<String, AttributeValue> var1);
    }
}

