/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the table when the backup was created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceTableDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceTableDetails.Builder, SourceTableDetails> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(SourceTableDetails::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableId").getter(getter(SourceTableDetails::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(SourceTableDetails::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<Long> TABLE_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TableSizeBytes").getter(getter(SourceTableDetails::tableSizeBytes))
            .setter(setter(Builder::tableSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSizeBytes").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(SourceTableDetails::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> TABLE_CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TableCreationDateTime").getter(getter(SourceTableDetails::tableCreationDateTime))
            .setter(setter(Builder::tableCreationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationDateTime").build())
            .build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(SourceTableDetails::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ItemCount")
            .getter(getter(SourceTableDetails::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingMode").getter(getter(SourceTableDetails::billingModeAsString))
            .setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            TABLE_ID_FIELD, TABLE_ARN_FIELD, TABLE_SIZE_BYTES_FIELD, KEY_SCHEMA_FIELD, TABLE_CREATION_DATE_TIME_FIELD,
            PROVISIONED_THROUGHPUT_FIELD, ITEM_COUNT_FIELD, BILLING_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final String tableId;

    private final String tableArn;

    private final Long tableSizeBytes;

    private final List<KeySchemaElement> keySchema;

    private final Instant tableCreationDateTime;

    private final ProvisionedThroughput provisionedThroughput;

    private final Long itemCount;

    private final String billingMode;

    private SourceTableDetails(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableId = builder.tableId;
        this.tableArn = builder.tableArn;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.keySchema = builder.keySchema;
        this.tableCreationDateTime = builder.tableCreationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.itemCount = builder.itemCount;
        this.billingMode = builder.billingMode;
    }

    /**
     * <p>
     * The name of the table for which the backup was created.
     * </p>
     * 
     * @return The name of the table for which the backup was created.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Unique identifier for the table for which the backup was created.
     * </p>
     * 
     * @return Unique identifier for the table for which the backup was created.
     */
    public final String tableId() {
        return tableId;
    }

    /**
     * <p>
     * ARN of the table for which backup was created.
     * </p>
     * 
     * @return ARN of the table for which backup was created.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * Size of the table in bytes. Note that this is an approximate value.
     * </p>
     * 
     * @return Size of the table in bytes. Note that this is an approximate value.
     */
    public final Long tableSizeBytes() {
        return tableSizeBytes;
    }

    /**
     * Returns true if the KeySchema property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Schema of the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeySchema()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Schema of the table.
     */
    public final List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * Time when the source table was created.
     * </p>
     * 
     * @return Time when the source table was created.
     */
    public final Instant tableCreationDateTime() {
        return tableCreationDateTime;
    }

    /**
     * <p>
     * Read IOPs and Write IOPS on the table when the backup was created.
     * </p>
     * 
     * @return Read IOPs and Write IOPS on the table when the backup was created.
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * Number of items in the table. Note that this is an approximate value.
     * </p>
     * 
     * @return Number of items in the table. Note that this is an approximate value.
     */
    public final Long itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
     * <code>PROVISIONED</code> for predictable workloads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend
     * using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
     *         using <code>PROVISIONED</code> for predictable workloads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
     *         recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public final BillingMode billingMode() {
        return BillingMode.fromValue(billingMode);
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
     * <code>PROVISIONED</code> for predictable workloads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend
     * using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
     *         using <code>PROVISIONED</code> for predictable workloads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
     *         recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public final String billingModeAsString() {
        return billingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(billingModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableDetails)) {
            return false;
        }
        SourceTableDetails other = (SourceTableDetails) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(tableId(), other.tableId())
                && Objects.equals(tableArn(), other.tableArn()) && Objects.equals(tableSizeBytes(), other.tableSizeBytes())
                && hasKeySchema() == other.hasKeySchema() && Objects.equals(keySchema(), other.keySchema())
                && Objects.equals(tableCreationDateTime(), other.tableCreationDateTime())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(itemCount(), other.itemCount())
                && Objects.equals(billingModeAsString(), other.billingModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceTableDetails").add("TableName", tableName()).add("TableId", tableId())
                .add("TableArn", tableArn()).add("TableSizeBytes", tableSizeBytes())
                .add("KeySchema", hasKeySchema() ? keySchema() : null).add("TableCreationDateTime", tableCreationDateTime())
                .add("ProvisionedThroughput", provisionedThroughput()).add("ItemCount", itemCount())
                .add("BillingMode", billingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "TableSizeBytes":
            return Optional.ofNullable(clazz.cast(tableSizeBytes()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "TableCreationDateTime":
            return Optional.ofNullable(clazz.cast(tableCreationDateTime()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceTableDetails, T> g) {
        return obj -> g.apply((SourceTableDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceTableDetails> {
        /**
         * <p>
         * The name of the table for which the backup was created.
         * </p>
         * 
         * @param tableName
         *        The name of the table for which the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Unique identifier for the table for which the backup was created.
         * </p>
         * 
         * @param tableId
         *        Unique identifier for the table for which the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * ARN of the table for which backup was created.
         * </p>
         * 
         * @param tableArn
         *        ARN of the table for which backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * Size of the table in bytes. Note that this is an approximate value.
         * </p>
         * 
         * @param tableSizeBytes
         *        Size of the table in bytes. Note that this is an approximate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSizeBytes(Long tableSizeBytes);

        /**
         * <p>
         * Schema of the table.
         * </p>
         * 
         * @param keySchema
         *        Schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * Schema of the table.
         * </p>
         * 
         * @param keySchema
         *        Schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * Schema of the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeySchemaElement>.Builder} avoiding the
         * need to create one manually via {@link List<KeySchemaElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeySchemaElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #keySchema(List<KeySchemaElement>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on {@link List<KeySchemaElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(List<KeySchemaElement>)
         */
        Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema);

        /**
         * <p>
         * Time when the source table was created.
         * </p>
         * 
         * @param tableCreationDateTime
         *        Time when the source table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableCreationDateTime(Instant tableCreationDateTime);

        /**
         * <p>
         * Read IOPs and Write IOPS on the table when the backup was created.
         * </p>
         * 
         * @param provisionedThroughput
         *        Read IOPs and Write IOPS on the table when the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Read IOPs and Write IOPS on the table when the backup was created.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding the need
         * to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * Number of items in the table. Note that this is an approximate value.
         * </p>
         * 
         * @param itemCount
         *        Number of items in the table. Note that this is an approximate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Long itemCount);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
         * <code>PROVISIONED</code> for predictable workloads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         * recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
         *        using <code>PROVISIONED</code> for predictable workloads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         *        recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
         * <code>PROVISIONED</code> for predictable workloads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         * recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
         *        using <code>PROVISIONED</code> for predictable workloads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         *        recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(BillingMode billingMode);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String tableId;

        private String tableArn;

        private Long tableSizeBytes;

        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();

        private Instant tableCreationDateTime;

        private ProvisionedThroughput provisionedThroughput;

        private Long itemCount;

        private String billingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableDetails model) {
            tableName(model.tableName);
            tableId(model.tableId);
            tableArn(model.tableArn);
            tableSizeBytes(model.tableSizeBytes);
            keySchema(model.keySchema);
            tableCreationDateTime(model.tableCreationDateTime);
            provisionedThroughput(model.provisionedThroughput);
            itemCount(model.itemCount);
            billingMode(model.billingMode);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableId() {
            return tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getTableArn() {
            return tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final Long getTableSizeBytes() {
            return tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> KeySchemaElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Instant getTableCreationDateTime() {
            return tableCreationDateTime;
        }

        @Override
        public final Builder tableCreationDateTime(Instant tableCreationDateTime) {
            this.tableCreationDateTime = tableCreationDateTime;
            return this;
        }

        public final void setTableCreationDateTime(Instant tableCreationDateTime) {
            this.tableCreationDateTime = tableCreationDateTime;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getItemCount() {
            return itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getBillingMode() {
            return billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public SourceTableDetails build() {
            return new SourceTableDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
