/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ExpectedAttributeMapCopier {
    static Map<String, ExpectedAttributeValue> copy(Map<String, ? extends ExpectedAttributeValue> expectedAttributeMapParam) {
        Map<String, ExpectedAttributeValue> map;
        if (expectedAttributeMapParam == null || expectedAttributeMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ExpectedAttributeValue> modifiableMap = new LinkedHashMap<>();
            expectedAttributeMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ExpectedAttributeValue> copyFromBuilder(
            Map<String, ? extends ExpectedAttributeValue.Builder> expectedAttributeMapParam) {
        Map<String, ExpectedAttributeValue> map;
        if (expectedAttributeMapParam == null || expectedAttributeMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ExpectedAttributeValue> modifiableMap = new LinkedHashMap<>();
            expectedAttributeMapParam.forEach((key, value) -> {
                ExpectedAttributeValue member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ExpectedAttributeValue.Builder> copyToBuilder(
            Map<String, ? extends ExpectedAttributeValue> expectedAttributeMapParam) {
        Map<String, ExpectedAttributeValue.Builder> map;
        if (expectedAttributeMapParam == null || expectedAttributeMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ExpectedAttributeValue.Builder> modifiableMap = new LinkedHashMap<>();
            expectedAttributeMapParam.forEach((key, value) -> {
                ExpectedAttributeValue.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
