/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.NestedAttributeName;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class QueryEnhancedRequest {
    private final QueryConditional queryConditional;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Boolean scanIndexForward;
    private final String select;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;
    private final List<NestedAttributeName> attributesToProject;
    private final String returnConsumedCapacity;

    private QueryEnhancedRequest(Builder builder) {
        this.queryConditional = builder.queryConditional;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.scanIndexForward = builder.scanIndexForward;
        this.select = builder.select;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.filterExpression = builder.filterExpression;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.attributesToProject = builder.attributesToProject != null ? Collections.unmodifiableList(builder.attributesToProject) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return QueryEnhancedRequest.builder().queryConditional(this.queryConditional).exclusiveStartKey(this.exclusiveStartKey).scanIndexForward(this.scanIndexForward).select(this.select).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression).returnConsumedCapacity(this.returnConsumedCapacity).addNestedAttributesToProject(this.attributesToProject);
    }

    public QueryConditional queryConditional() {
        return this.queryConditional;
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Boolean scanIndexForward() {
        return this.scanIndexForward;
    }

    public Select select() {
        return Select.fromValue((String)this.select);
    }

    public String selectAsString() {
        return this.select;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Expression filterExpression() {
        return this.filterExpression;
    }

    public List<String> attributesToProject() {
        return this.attributesToProject != null ? this.attributesToProject.stream().map(item -> String.join((CharSequence)".", item.elements())).collect(Collectors.toList()) : null;
    }

    public List<NestedAttributeName> nestedAttributesToProject() {
        return this.attributesToProject;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue((String)this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEnhancedRequest query = (QueryEnhancedRequest)o;
        if (this.queryConditional != null ? !this.queryConditional.equals(query.queryConditional) : query.queryConditional != null) {
            return false;
        }
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(query.exclusiveStartKey) : query.exclusiveStartKey != null) {
            return false;
        }
        if (this.scanIndexForward != null ? !this.scanIndexForward.equals(query.scanIndexForward) : query.scanIndexForward != null) {
            return false;
        }
        if (this.select != null ? !this.select.equals(query.select) : query.select != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(query.limit) : query.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(query.consistentRead) : query.consistentRead != null) {
            return false;
        }
        if (this.attributesToProject != null ? !this.attributesToProject.equals(query.attributesToProject) : query.attributesToProject != null) {
            return false;
        }
        if (this.returnConsumedCapacity != null ? !this.returnConsumedCapacity.equals(query.returnConsumedCapacity) : query.returnConsumedCapacity != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(query.filterExpression) : query.filterExpression == null;
    }

    public int hashCode() {
        int result = this.queryConditional != null ? this.queryConditional.hashCode() : 0;
        result = 31 * result + (this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0);
        result = 31 * result + (this.scanIndexForward != null ? this.scanIndexForward.hashCode() : 0);
        result = 31 * result + (this.select != null ? this.select.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        result = 31 * result + (this.attributesToProject != null ? this.attributesToProject.hashCode() : 0);
        result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private QueryConditional queryConditional;
        private Map<String, AttributeValue> exclusiveStartKey;
        private Boolean scanIndexForward;
        private String select;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;
        private List<NestedAttributeName> attributesToProject;
        private String returnConsumedCapacity;

        private Builder() {
        }

        public Builder queryConditional(QueryConditional queryConditional) {
            this.queryConditional = queryConditional;
            return this;
        }

        public Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public Builder select(Select select) {
            this.select = select == null ? null : select.toString();
            return this;
        }

        public Builder select(String select) {
            this.select = select;
            return this;
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey != null ? new HashMap<String, AttributeValue>(exclusiveStartKey) : null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public Builder attributesToProject(Collection<String> attributesToProject) {
            if (this.attributesToProject != null) {
                this.attributesToProject.clear();
            }
            if (attributesToProject != null) {
                this.addNestedAttributesToProject(new ArrayList<String>(attributesToProject).stream().map(NestedAttributeName::create).collect(Collectors.toList()));
            }
            return this;
        }

        public Builder attributesToProject(String ... attributesToProject) {
            return this.attributesToProject(Arrays.asList(attributesToProject));
        }

        public Builder addAttributeToProject(String attributeToProject) {
            if (attributeToProject != null) {
                this.addNestedAttributesToProject(NestedAttributeName.create(attributeToProject));
            }
            return this;
        }

        public Builder addNestedAttributesToProject(Collection<NestedAttributeName> nestedAttributeNames) {
            if (nestedAttributeNames != null) {
                Validate.noNullElements(nestedAttributeNames, (String)"nestedAttributeNames list must not contain null elements", (Object[])new Object[0]);
                if (this.attributesToProject == null) {
                    this.attributesToProject = new ArrayList<NestedAttributeName>(nestedAttributeNames);
                } else {
                    this.attributesToProject.addAll(nestedAttributeNames);
                }
            }
            return this;
        }

        public Builder addNestedAttributesToProject(NestedAttributeName ... nestedAttributeNames) {
            return this.addNestedAttributesToProject(Arrays.asList(nestedAttributeNames));
        }

        public Builder addNestedAttributeToProject(NestedAttributeName nestedAttributeName) {
            if (nestedAttributeName != null) {
                this.addNestedAttributesToProject(Arrays.asList(nestedAttributeName));
            }
            return this;
        }

        public Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity == null ? null : returnConsumedCapacity.toString();
            return this;
        }

        public Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public QueryEnhancedRequest build() {
            return new QueryEnhancedRequest(this);
        }
    }
}

