/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;

@SdkPublicApi
@ThreadSafe
public final class DeleteItemEnhancedRequest {
    private final Key key;
    private final Expression conditionExpression;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;
    private final String returnValuesOnConditionCheckFailure;

    private DeleteItemEnhancedRequest(Builder builder) {
        this.key = builder.key;
        this.conditionExpression = builder.conditionExpression;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeleteItemEnhancedRequest.builder().key(this.key).conditionExpression(this.conditionExpression).returnConsumedCapacity(this.returnConsumedCapacity).returnItemCollectionMetrics(this.returnItemCollectionMetrics).returnValuesOnConditionCheckFailure(this.returnValuesOnConditionCheckFailure);
    }

    public Key key() {
        return this.key;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue((String)this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue((String)this.returnItemCollectionMetrics);
    }

    public String returnItemCollectionMetricsAsString() {
        return this.returnItemCollectionMetrics;
    }

    public ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue((String)this.returnValuesOnConditionCheckFailure);
    }

    public String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteItemEnhancedRequest that = (DeleteItemEnhancedRequest)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.conditionExpression, that.conditionExpression) && Objects.equals(this.returnConsumedCapacity, that.returnConsumedCapacity) && Objects.equals(this.returnItemCollectionMetrics, that.returnItemCollectionMetrics) && Objects.equals(this.returnValuesOnConditionCheckFailure, that.returnValuesOnConditionCheckFailure);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
        result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
        result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
        result = 31 * result + (this.returnValuesOnConditionCheckFailure != null ? this.returnValuesOnConditionCheckFailure.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private Key key;
        private Expression conditionExpression;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;
        private String returnValuesOnConditionCheckFailure;

        private Builder() {
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Consumer<Key.Builder> keyConsumer) {
            Key.Builder builder = Key.builder();
            keyConsumer.accept(builder);
            return this.key(builder.build());
        }

        public Builder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity == null ? null : returnConsumedCapacity.toString();
            return this;
        }

        public Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString();
            return this;
        }

        public Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        public Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure == null ? null : returnValuesOnConditionCheckFailure.toString();
            return this;
        }

        public Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        public DeleteItemEnhancedRequest build() {
            return new DeleteItemEnhancedRequest(this);
        }
    }
}

