/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.OffsetDateTime;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsStringAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class OffsetDateTimeAsStringAttributeConverter
implements AttributeConverter<OffsetDateTime> {
    private static final Visitor VISITOR = new Visitor();

    public static OffsetDateTimeAsStringAttributeConverter create() {
        return new OffsetDateTimeAsStringAttributeConverter();
    }

    @Override
    public EnhancedType<OffsetDateTime> type() {
        return EnhancedType.of(OffsetDateTime.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(OffsetDateTime input) {
        return (AttributeValue)AttributeValue.builder().s(input.toString()).build();
    }

    @Override
    public OffsetDateTime transformTo(AttributeValue input) {
        try {
            if (input.s() != null) {
                return EnhancedAttributeValue.fromString(input.s()).convert(VISITOR);
            }
            return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class Visitor
    extends TypeConvertingVisitor<OffsetDateTime> {
        private Visitor() {
            super(OffsetDateTime.class, InstantAsStringAttributeConverter.class);
        }

        @Override
        public OffsetDateTime convertString(String value) {
            return OffsetDateTime.parse(value);
        }
    }
}

