/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.StringAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.CharSequenceStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class CharSequenceAttributeConverter
implements AttributeConverter<CharSequence> {
    private static final CharSequenceStringConverter CHAR_SEQUENCE_STRING_CONVERTER = CharSequenceStringConverter.create();
    private static final StringAttributeConverter STRING_ATTRIBUTE_CONVERTER = StringAttributeConverter.create();

    private CharSequenceAttributeConverter() {
    }

    public static CharSequenceAttributeConverter create() {
        return new CharSequenceAttributeConverter();
    }

    @Override
    public EnhancedType<CharSequence> type() {
        return EnhancedType.of(CharSequence.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(CharSequence input) {
        return (AttributeValue)AttributeValue.builder().s(CHAR_SEQUENCE_STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public CharSequence transformTo(AttributeValue input) {
        String string = STRING_ATTRIBUTE_CONVERTER.transformTo(input);
        return CHAR_SEQUENCE_STRING_CONVERTER.fromString(string);
    }
}

