/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class EqualToConditional
implements QueryConditional {
    private final Key key;

    public EqualToConditional(Key key) {
        this.key = key;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        String partitionKey = tableSchema.tableMetadata().indexPartitionKey(indexName);
        AttributeValue partitionValue = this.key.partitionKeyValue();
        if (partitionValue == null || partitionValue.equals((Object)AttributeValues.nullAttributeValue())) {
            throw new IllegalArgumentException("Partition key must be a valid scalar value to execute a query against. The provided partition key was set to null.");
        }
        Optional<AttributeValue> sortKeyValue = this.key.sortKeyValue();
        if (sortKeyValue.isPresent()) {
            Optional<String> sortKey = tableSchema.tableMetadata().indexSortKey(indexName);
            if (!sortKey.isPresent()) {
                throw new IllegalArgumentException("A sort key was supplied as part of a query conditional against an index that does not support a sort key. Index: " + indexName);
            }
            return this.partitionAndSortExpression(partitionKey, sortKey.get(), partitionValue, sortKeyValue.get());
        }
        return this.partitionOnlyExpression(partitionKey, partitionValue);
    }

    private Expression partitionOnlyExpression(String partitionKey, AttributeValue partitionValue) {
        String partitionKeyToken = EnhancedClientUtils.keyRef(partitionKey);
        String partitionKeyValueToken = EnhancedClientUtils.valueRef(partitionKey);
        String queryExpression = String.format("%s = %s", partitionKeyToken, partitionKeyValueToken);
        return Expression.builder().expression(queryExpression).expressionNames(Collections.singletonMap(partitionKeyToken, partitionKey)).expressionValues(Collections.singletonMap(partitionKeyValueToken, partitionValue)).build();
    }

    private Expression partitionAndSortExpression(String partitionKey, String sortKey, AttributeValue partitionValue, AttributeValue sortKeyValue) {
        if (EnhancedClientUtils.isNullAttributeValue(sortKeyValue)) {
            return this.partitionOnlyExpression(partitionKey, partitionValue);
        }
        String partitionKeyToken = EnhancedClientUtils.keyRef(partitionKey);
        String partitionKeyValueToken = EnhancedClientUtils.valueRef(partitionKey);
        String sortKeyToken = EnhancedClientUtils.keyRef(sortKey);
        String sortKeyValueToken = EnhancedClientUtils.valueRef(sortKey);
        String queryExpression = String.format("%s = %s AND %s = %s", partitionKeyToken, partitionKeyValueToken, sortKeyToken, sortKeyValueToken);
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(partitionKeyValueToken, partitionValue);
        expressionAttributeValues.put(sortKeyValueToken, sortKeyValue);
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put(partitionKeyToken, partitionKey);
        expressionAttributeNames.put(sortKeyToken, sortKey);
        return Expression.builder().expression(queryExpression).expressionValues(expressionAttributeValues).expressionNames(expressionAttributeNames).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualToConditional that = (EqualToConditional)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

