/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.internal.TransformIterable;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface PaginatedDatabaseOperation<RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(DynamoDbEnhancedClientExtension var1);

    public Function<RequestT, SdkIterable<ResponseT>> serviceCall(DynamoDbClient var1);

    public Function<RequestT, SdkPublisher<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public ResultT transformResponse(ResponseT var1, DynamoDbEnhancedClientExtension var2);

    default public SdkIterable<ResultT> execute(DynamoDbClient dynamoDbClient, DynamoDbEnhancedClientExtension extension) {
        RequestT request = this.generateRequest(extension);
        SdkIterable<ResponseT> response = this.serviceCall(dynamoDbClient).apply(request);
        return TransformIterable.of(response, r -> this.transformResponse(r, extension));
    }

    default public SdkPublisher<ResultT> executeAsync(DynamoDbAsyncClient dynamoDbAsyncClient, DynamoDbEnhancedClientExtension extension) {
        RequestT request = this.generateRequest(extension);
        SdkPublisher<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return response.map(r -> this.transformResponse(r, extension));
    }

    public OperationName operationName();
}

