/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.Collections;
import java.util.HashMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalKeyValues;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class BeginsWithConditional
implements QueryConditional {
    private final Key key;

    public BeginsWithConditional(Key key) {
        this.key = key;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalKeyValues queryConditionalKeyValues = QueryConditionalKeyValues.from(this.key, tableSchema, indexName);
        if (queryConditionalKeyValues.sortValue().equals((Object)AttributeValues.nullAttributeValue())) {
            throw new IllegalArgumentException("Attempt to query using a 'beginsWith' condition operator against a null sort key.");
        }
        if (queryConditionalKeyValues.sortValue().n() != null) {
            throw new IllegalArgumentException("Attempt to query using a 'beginsWith' condition operator against a numeric sort key.");
        }
        String partitionKeyToken = EnhancedClientUtils.keyRef(queryConditionalKeyValues.partitionKey());
        String partitionValueToken = EnhancedClientUtils.valueRef(queryConditionalKeyValues.partitionKey());
        String sortKeyToken = EnhancedClientUtils.keyRef(queryConditionalKeyValues.sortKey());
        String sortValueToken = EnhancedClientUtils.valueRef(queryConditionalKeyValues.sortKey());
        String queryExpression = String.format("%s = %s AND begins_with ( %s, %s )", partitionKeyToken, partitionValueToken, sortKeyToken, sortValueToken);
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(partitionValueToken, queryConditionalKeyValues.partitionValue());
        expressionAttributeValues.put(sortValueToken, queryConditionalKeyValues.sortValue());
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put(partitionKeyToken, queryConditionalKeyValues.partitionKey());
        expressionAttributeNames.put(sortKeyToken, queryConditionalKeyValues.sortKey());
        return Expression.builder().expression(queryExpression).expressionValues(Collections.unmodifiableMap(expressionAttributeValues)).expressionNames(expressionAttributeNames).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeginsWithConditional that = (BeginsWithConditional)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

