/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedGlobalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedLocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;

@SdkInternalApi
public class TableIndices {
    private final List<IndexMetadata> indices;

    public TableIndices(List<IndexMetadata> indices) {
        this.indices = indices;
    }

    public List<EnhancedLocalSecondaryIndex> localSecondaryIndices() {
        return Collections.unmodifiableList(this.indices.stream().filter(index -> !TableMetadata.primaryIndexName().equals(index.name())).filter(index -> !index.partitionKey().isPresent()).map(TableIndices::mapIndexMetadataToEnhancedLocalSecondaryIndex).collect(Collectors.toList()));
    }

    public List<EnhancedGlobalSecondaryIndex> globalSecondaryIndices() {
        return Collections.unmodifiableList(this.indices.stream().filter(index -> !TableMetadata.primaryIndexName().equals(index.name())).filter(index -> index.partitionKey().isPresent()).map(TableIndices::mapIndexMetadataToEnhancedGlobalSecondaryIndex).collect(Collectors.toList()));
    }

    private static EnhancedLocalSecondaryIndex mapIndexMetadataToEnhancedLocalSecondaryIndex(IndexMetadata indexMetadata) {
        return EnhancedLocalSecondaryIndex.builder().indexName(indexMetadata.name()).projection(pb -> pb.projectionType(ProjectionType.ALL)).build();
    }

    private static EnhancedGlobalSecondaryIndex mapIndexMetadataToEnhancedGlobalSecondaryIndex(IndexMetadata indexMetadata) {
        return EnhancedGlobalSecondaryIndex.builder().indexName(indexMetadata.name()).projection(pb -> pb.projectionType(ProjectionType.ALL)).build();
    }
}

