/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.DefaultDynamoDbIndex;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.IndexType;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.CreateTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DescribeTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.GetItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PutItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.QueryOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.ScanOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.UpdateItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedResponse;
import software.amazon.awssdk.enhanced.dynamodb.model.DescribeTableEnhancedResponse;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedGlobalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedLocalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedResponse;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedResponse;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedResponse;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;

@SdkInternalApi
public class DefaultDynamoDbTable<T>
implements DynamoDbTable<T> {
    private final DynamoDbClient dynamoDbClient;
    private final DynamoDbEnhancedClientExtension extension;
    private final TableSchema<T> tableSchema;
    private final String tableName;

    DefaultDynamoDbTable(DynamoDbClient dynamoDbClient, DynamoDbEnhancedClientExtension extension, TableSchema<T> tableSchema, String tableName) {
        this.dynamoDbClient = dynamoDbClient;
        this.extension = extension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public DynamoDbEnhancedClientExtension mapperExtension() {
        return this.extension;
    }

    @Override
    public TableSchema<T> tableSchema() {
        return this.tableSchema;
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public DefaultDynamoDbIndex<T> index(String indexName) {
        this.tableSchema.tableMetadata().indexPartitionKey(indexName);
        return new DefaultDynamoDbIndex<T>(this.dynamoDbClient, this.extension, this.tableSchema, this.tableName, indexName);
    }

    @Override
    public void createTable(CreateTableEnhancedRequest request) {
        CreateTableOperation operation = CreateTableOperation.create(request);
        operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public void createTable(Consumer<CreateTableEnhancedRequest.Builder> requestConsumer) {
        CreateTableEnhancedRequest.Builder builder = CreateTableEnhancedRequest.builder();
        requestConsumer.accept(builder);
        this.createTable(builder.build());
    }

    @Override
    public void createTable() {
        Map<IndexType, List<IndexMetadata>> indexGroups = this.splitSecondaryIndicesToLocalAndGlobalOnes();
        this.createTable(CreateTableEnhancedRequest.builder().localSecondaryIndices(this.extractLocalSecondaryIndices(indexGroups)).globalSecondaryIndices(this.extractGlobalSecondaryIndices(indexGroups)).build());
    }

    private Map<IndexType, List<IndexMetadata>> splitSecondaryIndicesToLocalAndGlobalOnes() {
        Collection<IndexMetadata> indices = this.tableSchema.tableMetadata().indices();
        return indices.stream().filter(index -> !TableMetadata.primaryIndexName().equals(index.name())).collect(Collectors.groupingBy(metadata -> {
            String partitionKeyName = metadata.partitionKey().map(KeyAttributeMetadata::name).orElse(null);
            if (partitionKeyName == null) {
                return IndexType.LSI;
            }
            return IndexType.GSI;
        }));
    }

    private List<EnhancedLocalSecondaryIndex> extractLocalSecondaryIndices(Map<IndexType, List<IndexMetadata>> indicesGroups) {
        return indicesGroups.getOrDefault((Object)IndexType.LSI, Collections.emptyList()).stream().map(this::mapIndexMetadataToEnhancedLocalSecondaryIndex).collect(Collectors.toList());
    }

    private EnhancedLocalSecondaryIndex mapIndexMetadataToEnhancedLocalSecondaryIndex(IndexMetadata indexMetadata) {
        return EnhancedLocalSecondaryIndex.builder().indexName(indexMetadata.name()).projection(pb -> pb.projectionType(ProjectionType.ALL)).build();
    }

    private List<EnhancedGlobalSecondaryIndex> extractGlobalSecondaryIndices(Map<IndexType, List<IndexMetadata>> indicesGroups) {
        return indicesGroups.getOrDefault((Object)IndexType.GSI, Collections.emptyList()).stream().map(this::mapIndexMetadataToEnhancedGlobalSecondaryIndex).collect(Collectors.toList());
    }

    private EnhancedGlobalSecondaryIndex mapIndexMetadataToEnhancedGlobalSecondaryIndex(IndexMetadata indexMetadata) {
        return EnhancedGlobalSecondaryIndex.builder().indexName(indexMetadata.name()).projection(pb -> pb.projectionType(ProjectionType.ALL)).build();
    }

    @Override
    public T deleteItem(DeleteItemEnhancedRequest request) {
        DeleteItemOperation operation = DeleteItemOperation.create(request);
        return ((DeleteItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient)).attributes();
    }

    @Override
    public T deleteItem(Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
        DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return (T)this.deleteItem((T)builder.build());
    }

    @Override
    public T deleteItem(Key key) {
        return (T)this.deleteItem((T)((Consumer<DeleteItemEnhancedRequest.Builder>)r -> r.key(key)));
    }

    @Override
    public T deleteItem(T keyItem) {
        return (T)this.deleteItem((T)this.keyFrom(keyItem));
    }

    @Override
    public DeleteItemEnhancedResponse<T> deleteItemWithResponse(DeleteItemEnhancedRequest request) {
        DeleteItemOperation operation = DeleteItemOperation.create(request);
        return (DeleteItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public DeleteItemEnhancedResponse<T> deleteItemWithResponse(Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
        DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.deleteItemWithResponse(builder.build());
    }

    @Override
    public T getItem(GetItemEnhancedRequest request) {
        GetItemOperation operation = GetItemOperation.create(request);
        return ((GetItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient)).attributes();
    }

    @Override
    public T getItem(Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
        GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return (T)this.getItem((T)builder.build());
    }

    @Override
    public T getItem(Key key) {
        return (T)this.getItem((T)((Consumer<GetItemEnhancedRequest.Builder>)r -> r.key(key)));
    }

    @Override
    public T getItem(T keyItem) {
        return (T)this.getItem((T)this.keyFrom(keyItem));
    }

    @Override
    public GetItemEnhancedResponse<T> getItemWithResponse(Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
        GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.getItemWithResponse(builder.build());
    }

    @Override
    public GetItemEnhancedResponse<T> getItemWithResponse(GetItemEnhancedRequest request) {
        GetItemOperation operation = GetItemOperation.create(request);
        return (GetItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PageIterable<T> query(QueryEnhancedRequest request) {
        QueryOperation operation = QueryOperation.create(request);
        return operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PageIterable<T> query(Consumer<QueryEnhancedRequest.Builder> requestConsumer) {
        QueryEnhancedRequest.Builder builder = QueryEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.query(builder.build());
    }

    @Override
    public PageIterable<T> query(QueryConditional queryConditional) {
        return this.query((QueryEnhancedRequest.Builder r) -> r.queryConditional(queryConditional));
    }

    @Override
    public void putItem(PutItemEnhancedRequest<T> request) {
        PutItemOperation<T> operation = PutItemOperation.create(request);
        operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public void putItem(Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
        PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        this.putItem((T)builder.build());
    }

    @Override
    public void putItem(T item) {
        this.putItem((T)((Consumer<PutItemEnhancedRequest.Builder>)r -> r.item(item)));
    }

    @Override
    public PutItemEnhancedResponse<T> putItemWithResponse(PutItemEnhancedRequest<T> request) {
        PutItemOperation<T> operation = PutItemOperation.create(request);
        return (PutItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PutItemEnhancedResponse<T> putItemWithResponse(Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
        PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        return this.putItemWithResponse(builder.build());
    }

    @Override
    public PageIterable<T> scan(ScanEnhancedRequest request) {
        ScanOperation operation = ScanOperation.create(request);
        return operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PageIterable<T> scan(Consumer<ScanEnhancedRequest.Builder> requestConsumer) {
        ScanEnhancedRequest.Builder builder = ScanEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.scan(builder.build());
    }

    @Override
    public PageIterable<T> scan() {
        return this.scan(ScanEnhancedRequest.builder().build());
    }

    @Override
    public T updateItem(UpdateItemEnhancedRequest<T> request) {
        UpdateItemOperation<T> operation = UpdateItemOperation.create(request);
        return ((UpdateItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient)).attributes();
    }

    @Override
    public T updateItem(Consumer<UpdateItemEnhancedRequest.Builder<T>> requestConsumer) {
        UpdateItemEnhancedRequest.Builder<T> builder = UpdateItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        return (T)this.updateItem((T)builder.build());
    }

    @Override
    public T updateItem(T item) {
        return (T)this.updateItem((T)((Consumer<UpdateItemEnhancedRequest.Builder>)r -> r.item(item)));
    }

    @Override
    public UpdateItemEnhancedResponse<T> updateItemWithResponse(UpdateItemEnhancedRequest<T> request) {
        UpdateItemOperation<T> operation = UpdateItemOperation.create(request);
        return (UpdateItemEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public UpdateItemEnhancedResponse<T> updateItemWithResponse(Consumer<UpdateItemEnhancedRequest.Builder<T>> requestConsumer) {
        UpdateItemEnhancedRequest.Builder<T> builder = UpdateItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        return this.updateItemWithResponse(builder.build());
    }

    @Override
    public Key keyFrom(T item) {
        return EnhancedClientUtils.createKeyFromItem(item, this.tableSchema, TableMetadata.primaryIndexName());
    }

    @Override
    public void deleteTable() {
        DeleteTableOperation operation = DeleteTableOperation.create();
        operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public DescribeTableEnhancedResponse describeTable() {
        DescribeTableOperation operation = DescribeTableOperation.create();
        return (DescribeTableEnhancedResponse)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbTable that = (DefaultDynamoDbTable)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }
}

