/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class NestedAttributeName {
    private final List<String> elements;

    private NestedAttributeName(List<String> nestedAttributeNames) {
        Validate.validState((nestedAttributeNames != null ? 1 : 0) != 0, (String)"nestedAttributeNames must not be null.", (Object[])new Object[0]);
        Validate.notEmpty(nestedAttributeNames, (String)"nestedAttributeNames must not be empty", (Object[])new Object[0]);
        Validate.noNullElements(nestedAttributeNames, (String)"nestedAttributeNames must not contain null values", (Object[])new Object[0]);
        this.elements = Collections.unmodifiableList(nestedAttributeNames);
    }

    public static NestedAttributeName create(String element) {
        return new Builder().addElement(element).build();
    }

    public static NestedAttributeName create(String ... elements) {
        return new Builder().elements(elements).build();
    }

    public static NestedAttributeName create(List<String> elements) {
        return new Builder().elements(elements).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> elements() {
        return this.elements;
    }

    public Builder toBuilder() {
        return NestedAttributeName.builder().elements(this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedAttributeName that = (NestedAttributeName)o;
        return this.elements != null ? this.elements.equals(that.elements) : that.elements == null;
    }

    public int hashCode() {
        return this.elements != null ? this.elements.hashCode() : 0;
    }

    public String toString() {
        return this.elements == null ? "" : this.elements.stream().collect(Collectors.joining("."));
    }

    @NotThreadSafe
    public static class Builder {
        private List<String> elements = null;

        private Builder() {
        }

        public Builder addElement(String element) {
            if (this.elements == null) {
                this.elements = new ArrayList<String>();
            }
            this.elements.add(element);
            return this;
        }

        public Builder addElements(String ... elements) {
            if (this.elements == null) {
                this.elements = new ArrayList<String>();
            }
            this.elements.addAll(Arrays.asList(elements));
            return this;
        }

        public Builder addElements(List<String> elements) {
            if (this.elements == null) {
                this.elements = new ArrayList<String>();
            }
            this.elements.addAll(elements);
            return this;
        }

        public Builder elements(String ... elements) {
            this.elements = new ArrayList<String>(Arrays.asList(elements));
            return this;
        }

        public Builder elements(List<String> elements) {
            this.elements = new ArrayList<String>(elements);
            return this;
        }

        public NestedAttributeName build() {
            return new NestedAttributeName(this.elements);
        }
    }
}

