/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterProviderResolver;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ResolvedImmutableAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableTag;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
@ThreadSafe
public final class StaticImmutableTableSchema<T, B>
implements TableSchema<T> {
    private final List<ResolvedImmutableAttribute<T, B>> attributeMappers;
    private final Supplier<B> newBuilderSupplier;
    private final Function<B, T> buildItemFunction;
    private final Map<String, ResolvedImmutableAttribute<T, B>> indexedMappers;
    private final StaticTableMetadata tableMetadata;
    private final EnhancedType<T> itemType;
    private final AttributeConverterProvider attributeConverterProvider;
    private final Map<String, FlattenedMapper<T, B, ?>> indexedFlattenedMappers;
    private final List<String> attributeNames;

    private StaticImmutableTableSchema(Builder<T, B> builder) {
        StaticTableMetadata.Builder tableMetadataBuilder = StaticTableMetadata.builder();
        this.attributeConverterProvider = ConverterProviderResolver.resolveProviders(((Builder)builder).attributeConverterProviders);
        Stream attributesStream = ((Builder)builder).attributes == null ? Stream.empty() : ((Builder)builder).attributes.stream().map(a -> a.resolve(this.attributeConverterProvider));
        ArrayList mutableAttributeMappers = new ArrayList();
        HashMap mutableIndexedMappers = new HashMap();
        LinkedHashSet mutableAttributeNames = new LinkedHashSet();
        Stream.concat(attributesStream, ((Builder)builder).additionalAttributes.stream()).forEach(resolvedAttribute -> {
            String attributeName = resolvedAttribute.attributeName();
            if (mutableAttributeNames.contains(attributeName)) {
                throw new IllegalArgumentException("Attempt to add an attribute to a mapper that already has one with the same name. [Attribute name: " + attributeName + "]");
            }
            mutableAttributeNames.add(attributeName);
            mutableAttributeMappers.add(resolvedAttribute);
            mutableIndexedMappers.put(attributeName, resolvedAttribute);
            tableMetadataBuilder.mergeWith(resolvedAttribute.tableMetadata());
        });
        HashMap mutableFlattenedMappers = new HashMap();
        ((Builder)builder).flattenedMappers.forEach(flattenedMapper -> {
            ((FlattenedMapper)flattenedMapper).otherItemTableSchema.attributeNames().forEach(attributeName -> {
                if (mutableAttributeNames.contains(attributeName)) {
                    throw new IllegalArgumentException("Attempt to add an attribute to a mapper that already has one with the same name. [Attribute name: " + attributeName + "]");
                }
                mutableAttributeNames.add(attributeName);
                mutableFlattenedMappers.put(attributeName, flattenedMapper);
            });
            tableMetadataBuilder.mergeWith(flattenedMapper.getOtherItemTableSchema().tableMetadata());
        });
        if (((Builder)builder).tags != null) {
            ((Builder)builder).tags.forEach(staticTableTag -> staticTableTag.modifyMetadata().accept(tableMetadataBuilder));
        }
        this.attributeMappers = Collections.unmodifiableList(mutableAttributeMappers);
        this.indexedMappers = Collections.unmodifiableMap(mutableIndexedMappers);
        this.attributeNames = Collections.unmodifiableList(new ArrayList(mutableAttributeNames));
        this.indexedFlattenedMappers = Collections.unmodifiableMap(mutableFlattenedMappers);
        this.newBuilderSupplier = ((Builder)builder).newBuilderSupplier;
        this.buildItemFunction = ((Builder)builder).buildItemFunction;
        this.tableMetadata = tableMetadataBuilder.build();
        this.itemType = ((Builder)builder).itemType;
    }

    public static <T, B> Builder<T, B> builder(Class<T> itemClass, Class<B> builderClass) {
        return new Builder(EnhancedType.of(itemClass), EnhancedType.of(builderClass));
    }

    public static <T, B> Builder<T, B> builder(EnhancedType<T> itemType, EnhancedType<B> builderType) {
        return new Builder(itemType, builderType);
    }

    @Override
    public StaticTableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public T mapToItem(Map<String, AttributeValue> attributeMap, boolean preserveEmptyObject) {
        Object builder = null;
        if (preserveEmptyObject) {
            builder = this.constructNewBuilder();
        }
        LinkedHashMap flattenedAttributeValuesMap = new LinkedHashMap();
        for (Map.Entry<String, AttributeValue> entry : attributeMap.entrySet()) {
            String key = entry.getKey();
            AttributeValue value = entry.getValue();
            if (EnhancedClientUtils.isNullAttributeValue(value)) continue;
            ResolvedImmutableAttribute<T, B> attributeMapper = this.indexedMappers.get(key);
            if (attributeMapper != null) {
                if (builder == null) {
                    builder = this.constructNewBuilder();
                }
                attributeMapper.updateItemMethod().accept(builder, value);
                continue;
            }
            FlattenedMapper<T, B, ?> flattenedMapper = this.indexedFlattenedMappers.get(key);
            if (flattenedMapper == null) continue;
            HashMap<String, AttributeValue> flattenedAttributeValues = (HashMap<String, AttributeValue>)flattenedAttributeValuesMap.get(flattenedMapper);
            if (flattenedAttributeValues == null) {
                flattenedAttributeValues = new HashMap<String, AttributeValue>();
            }
            flattenedAttributeValues.put(key, value);
            flattenedAttributeValuesMap.put(flattenedMapper, flattenedAttributeValues);
        }
        for (Map.Entry<String, Object> entry : flattenedAttributeValuesMap.entrySet()) {
            builder = ((FlattenedMapper)((Object)entry.getKey())).mapToItem(builder, this::constructNewBuilder, (Map)entry.getValue());
        }
        return builder == null ? null : (T)this.buildItemFunction.apply(builder);
    }

    @Override
    public T mapToItem(Map<String, AttributeValue> attributeMap) {
        return this.mapToItem(attributeMap, false);
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, boolean ignoreNulls) {
        HashMap attributeValueMap = new HashMap();
        this.attributeMappers.forEach(attributeMapper -> {
            String attributeKey = attributeMapper.attributeName();
            AttributeValue attributeValue = attributeMapper.attributeGetterMethod().apply(item);
            if (!ignoreNulls || !EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                attributeValueMap.put(attributeKey, attributeValue);
            }
        });
        this.indexedFlattenedMappers.forEach((name, flattenedMapper) -> attributeValueMap.putAll(((FlattenedMapper)flattenedMapper).itemToMap(item, ignoreNulls)));
        return Collections.unmodifiableMap(attributeValueMap);
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, Collection<String> attributes) {
        HashMap attributeValueMap = new HashMap();
        attributes.forEach(key -> {
            AttributeValue attributeValue = this.attributeValue(item, (String)key);
            if (attributeValue == null || !EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                attributeValueMap.put(key, attributeValue);
            }
        });
        return Collections.unmodifiableMap(attributeValueMap);
    }

    @Override
    public AttributeValue attributeValue(T item, String key) {
        ResolvedImmutableAttribute<T, B> attributeMapper = this.indexedMappers.get(key);
        if (attributeMapper == null) {
            FlattenedMapper<T, B, ?> flattenedMapper = this.indexedFlattenedMappers.get(key);
            if (flattenedMapper == null) {
                throw new IllegalArgumentException(String.format("TableSchema does not know how to retrieve requested attribute '%s' from mapped object.", key));
            }
            return ((FlattenedMapper)flattenedMapper).attributeValue(item, key);
        }
        AttributeValue attributeValue = attributeMapper.attributeGetterMethod().apply(item);
        return EnhancedClientUtils.isNullAttributeValue(attributeValue) ? null : attributeValue;
    }

    @Override
    public EnhancedType<T> itemType() {
        return this.itemType;
    }

    @Override
    public List<String> attributeNames() {
        return this.attributeNames;
    }

    @Override
    public boolean isAbstract() {
        return this.buildItemFunction == null;
    }

    public AttributeConverterProvider attributeConverterProvider() {
        return this.attributeConverterProvider;
    }

    private B constructNewBuilder() {
        if (this.newBuilderSupplier == null) {
            throw new UnsupportedOperationException("An abstract TableSchema cannot be used to map a database record to a concrete object. Add a 'newItemBuilder' to the TableSchema to give it the ability to create mapped objects.");
        }
        return this.newBuilderSupplier.get();
    }

    @Override
    public AttributeConverter<T> converterForAttribute(Object key) {
        ResolvedImmutableAttribute<T, B> resolvedImmutableAttribute = this.indexedMappers.get(key);
        if (resolvedImmutableAttribute != null) {
            return resolvedImmutableAttribute.attributeConverter();
        }
        FlattenedMapper<T, B, ?> flattenedMapper = this.indexedFlattenedMappers.get(key);
        if (flattenedMapper != null) {
            return flattenedMapper.getOtherItemTableSchema().converterForAttribute(key);
        }
        return null;
    }

    @NotThreadSafe
    public static final class Builder<T, B> {
        private final EnhancedType<T> itemType;
        private final EnhancedType<B> builderType;
        private final List<ResolvedImmutableAttribute<T, B>> additionalAttributes = new ArrayList<ResolvedImmutableAttribute<T, B>>();
        private final List<FlattenedMapper<T, B, ?>> flattenedMappers = new ArrayList();
        private List<ImmutableAttribute<T, B, ?>> attributes;
        private Supplier<B> newBuilderSupplier;
        private Function<B, T> buildItemFunction;
        private List<StaticTableTag> tags;
        private List<AttributeConverterProvider> attributeConverterProviders = Collections.singletonList(ConverterProviderResolver.defaultConverterProvider());

        private Builder(EnhancedType<T> itemType, EnhancedType<B> builderType) {
            this.itemType = itemType;
            this.builderType = builderType;
        }

        public Builder<T, B> newItemBuilder(Supplier<B> newBuilderMethod, Function<B, T> buildMethod) {
            this.newBuilderSupplier = newBuilderMethod;
            this.buildItemFunction = buildMethod;
            return this;
        }

        @SafeVarargs
        public final Builder<T, B> attributes(ImmutableAttribute<T, B, ?> ... immutableAttributes) {
            this.attributes = Arrays.asList(immutableAttributes);
            return this;
        }

        public Builder<T, B> attributes(Collection<ImmutableAttribute<T, B, ?>> immutableAttributes) {
            this.attributes = new ArrayList(immutableAttributes);
            return this;
        }

        public <R> Builder<T, B> addAttribute(EnhancedType<R> attributeType, Consumer<ImmutableAttribute.Builder<T, B, R>> immutableAttribute) {
            ImmutableAttribute.Builder<T, B, R> builder = ImmutableAttribute.builder(this.itemType, this.builderType, attributeType);
            immutableAttribute.accept(builder);
            return this.addAttribute(builder.build());
        }

        public <R> Builder<T, B> addAttribute(Class<R> attributeClass, Consumer<ImmutableAttribute.Builder<T, B, R>> immutableAttribute) {
            return this.addAttribute(EnhancedType.of(attributeClass), immutableAttribute);
        }

        public Builder<T, B> addAttribute(ImmutableAttribute<T, B, ?> immutableAttribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(immutableAttribute);
            return this;
        }

        public Builder<T, B> tags(StaticTableTag ... staticTableTags) {
            this.tags = Arrays.asList(staticTableTags);
            return this;
        }

        public Builder<T, B> tags(Collection<StaticTableTag> staticTableTags) {
            this.tags = new ArrayList<StaticTableTag>(staticTableTags);
            return this;
        }

        public Builder<T, B> addTag(StaticTableTag staticTableTag) {
            if (this.tags == null) {
                this.tags = new ArrayList<StaticTableTag>();
            }
            this.tags.add(staticTableTag);
            return this;
        }

        public <T1> Builder<T, B> flatten(TableSchema<T1> otherTableSchema, Function<T, T1> otherItemGetter, BiConsumer<B, T1> otherItemSetter) {
            if (otherTableSchema.isAbstract()) {
                throw new IllegalArgumentException("Cannot flatten an abstract TableSchema. You must supply a concrete TableSchema that is able to create items");
            }
            FlattenedMapper flattenedMapper = new FlattenedMapper(otherItemGetter, otherItemSetter, otherTableSchema);
            this.flattenedMappers.add(flattenedMapper);
            return this;
        }

        public Builder<T, B> extend(StaticImmutableTableSchema<? super T, ? super B> superTableSchema) {
            Stream<ResolvedImmutableAttribute<ResolvedImmutableAttribute, B>> attributeStream = Builder.upcastingTransformForAttributes(((StaticImmutableTableSchema)superTableSchema).attributeMappers);
            attributeStream.forEach(this.additionalAttributes::add);
            return this;
        }

        public Builder<T, B> attributeConverterProviders(AttributeConverterProvider ... attributeConverterProviders) {
            this.attributeConverterProviders = Arrays.asList(attributeConverterProviders);
            return this;
        }

        public Builder<T, B> attributeConverterProviders(List<AttributeConverterProvider> attributeConverterProviders) {
            this.attributeConverterProviders = new ArrayList<AttributeConverterProvider>(attributeConverterProviders);
            return this;
        }

        public StaticImmutableTableSchema<T, B> build() {
            return new StaticImmutableTableSchema(this);
        }

        private static <T extends T1, T1, B extends B1, B1> Stream<ResolvedImmutableAttribute<T, B>> upcastingTransformForAttributes(Collection<ResolvedImmutableAttribute<T1, B1>> superAttributes) {
            return superAttributes.stream().map(attribute -> attribute.transform(x -> x, x -> x));
        }
    }

    private static class FlattenedMapper<T, B, T1> {
        private final Function<T, T1> otherItemGetter;
        private final BiConsumer<B, T1> otherItemSetter;
        private final TableSchema<T1> otherItemTableSchema;

        private FlattenedMapper(Function<T, T1> otherItemGetter, BiConsumer<B, T1> otherItemSetter, TableSchema<T1> otherItemTableSchema) {
            this.otherItemGetter = otherItemGetter;
            this.otherItemSetter = otherItemSetter;
            this.otherItemTableSchema = otherItemTableSchema;
        }

        public TableSchema<T1> getOtherItemTableSchema() {
            return this.otherItemTableSchema;
        }

        private B mapToItem(B thisBuilder, Supplier<B> thisBuilderConstructor, Map<String, AttributeValue> attributeValues) {
            T1 otherItem = this.otherItemTableSchema.mapToItem(attributeValues);
            if (otherItem != null) {
                if (thisBuilder == null) {
                    thisBuilder = thisBuilderConstructor.get();
                }
                this.otherItemSetter.accept(thisBuilder, otherItem);
            }
            return thisBuilder;
        }

        private Map<String, AttributeValue> itemToMap(T item, boolean ignoreNulls) {
            T1 otherItem = this.otherItemGetter.apply(item);
            if (otherItem == null) {
                return Collections.emptyMap();
            }
            return this.otherItemTableSchema.itemToMap(otherItem, ignoreNulls);
        }

        private AttributeValue attributeValue(T item, String attributeName) {
            T1 otherItem = this.otherItemGetter.apply(item);
            if (otherItem == null) {
                return null;
            }
            AttributeValue attributeValue = this.otherItemTableSchema.attributeValue(otherItem, attributeName);
            return EnhancedClientUtils.isNullAttributeValue(attributeValue) ? null : attributeValue;
        }
    }
}

