/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Document;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class DefaultDocument
implements Document {
    private final Map<String, AttributeValue> itemMap;

    private DefaultDocument(Map<String, AttributeValue> itemMap) {
        this.itemMap = itemMap;
    }

    public static DefaultDocument create(Map<String, AttributeValue> itemMap) {
        return new DefaultDocument(itemMap);
    }

    @Override
    public <T> T getItem(MappedTableResource<T> mappedTableResource) {
        return EnhancedClientUtils.readAndTransformSingleItem(this.itemMap, mappedTableResource.tableSchema(), DefaultOperationContext.create(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDocument that = (DefaultDocument)o;
        return this.itemMap != null ? this.itemMap.equals(that.itemMap) : that.itemMap == null;
    }

    public int hashCode() {
        return this.itemMap != null ? this.itemMap.hashCode() : 0;
    }
}

