/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.AtomicCounterTag;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.AtomicCounter;
import software.amazon.awssdk.enhanced.dynamodb.internal.update.UpdateExpressionUtils;
import software.amazon.awssdk.enhanced.dynamodb.update.SetAction;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateExpression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Logger;

@SdkPublicApi
public final class AtomicCounterExtension
implements DynamoDbEnhancedClientExtension {
    private static final Logger log = Logger.loggerFor(AtomicCounterExtension.class);

    private AtomicCounterExtension() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        Map<String, AtomicCounter> counters = AtomicCounterTag.resolve(context.tableMetadata());
        WriteModification.Builder modificationBuilder = WriteModification.builder();
        if (CollectionUtils.isNullOrEmpty(counters)) {
            return modificationBuilder.build();
        }
        switch (context.operationName()) {
            case PUT_ITEM: {
                modificationBuilder.transformedItem(this.addToItem(counters, context.items()));
                break;
            }
            case UPDATE_ITEM: {
                modificationBuilder.updateExpression(this.createUpdateExpression(counters));
                modificationBuilder.transformedItem(this.filterFromItem(counters, context.items()));
                break;
            }
        }
        return modificationBuilder.build();
    }

    private UpdateExpression createUpdateExpression(Map<String, AtomicCounter> counters) {
        return UpdateExpression.builder().actions(counters.entrySet().stream().map(this::counterAction).collect(Collectors.toList())).build();
    }

    private Map<String, AttributeValue> addToItem(Map<String, AtomicCounter> counters, Map<String, AttributeValue> items) {
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(items);
        counters.forEach((attribute, counter) -> itemToTransform.put((String)attribute, this.attributeValue(counter.startValue().value())));
        return Collections.unmodifiableMap(itemToTransform);
    }

    private Map<String, AttributeValue> filterFromItem(Map<String, AtomicCounter> counters, Map<String, AttributeValue> items) {
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(items);
        ArrayList<String> removedAttributes = new ArrayList<String>();
        for (String attributeName : counters.keySet()) {
            if (!itemToTransform.containsKey(attributeName)) continue;
            itemToTransform.remove(attributeName);
            removedAttributes.add(attributeName);
        }
        if (!removedAttributes.isEmpty()) {
            log.debug(() -> String.format("Filtered atomic counter attributes from existing update item to avoid collisions: %s", String.join((CharSequence)",", removedAttributes)));
        }
        return Collections.unmodifiableMap(itemToTransform);
    }

    private SetAction counterAction(Map.Entry<String, AtomicCounter> e) {
        String attributeName = e.getKey();
        AtomicCounter counter = e.getValue();
        String startValueName = attributeName + counter.startValue().name();
        String deltaValueName = attributeName + counter.delta().name();
        String valueExpression = UpdateExpressionUtils.ifNotExists(attributeName, startValueName) + " + " + EnhancedClientUtils.valueRef(deltaValueName);
        AttributeValue startValue = this.attributeValue(counter.startValue().value() - counter.delta().value());
        AttributeValue deltaValue = this.attributeValue(counter.delta().value());
        return SetAction.builder().path(EnhancedClientUtils.keyRef(attributeName)).value(valueExpression).putExpressionName(EnhancedClientUtils.keyRef(attributeName), attributeName).putExpressionValue(EnhancedClientUtils.valueRef(startValueName), startValue).putExpressionValue(EnhancedClientUtils.valueRef(deltaValueName), deltaValue).build();
    }

    private AttributeValue attributeValue(long value) {
        return AtomicCounter.CounterAttribute.resolvedValue(value);
    }

    public static final class Builder {
        private Builder() {
        }

        public AtomicCounterExtension build() {
            return new AtomicCounterExtension();
        }
    }
}

