/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package software.amazon.awssdk.enhanced.dynamodb.mapper.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanTableSchemaAttributeTags;

/**
 * Denotes this attribute as being the optional primary sort key of the DynamoDb table. This attribute must map to a
 * DynamoDb scalar type (string, number or binary) to be valid.
 *
 * Example using {@link DynamoDbSortKey}:
 * <pre>
 * {@code
 *    @DynamoDbBean
 *    public class Customer {
 *        private String accountId;
 *        private int subId;
 *
 *        @DynamoDbPartitionKey
 *        public String getAccountId() {
 *              return this.accountId;
 *        }
 *
 *        public void setAccountId(String accountId) {
 *              this.accountId = accountId;
 *         }
 *
 *        @DynamoDbSortKey
 *        public int getSubId() {
 *              return this.subId;
 *        }
 *        public void setSubId(int subId) {
 *              this.subId = subId;
 *        }
 *    }
 * }
 * </pre>
 */
@SdkPublicApi
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@BeanTableSchemaAttributeTag(BeanTableSchemaAttributeTags.class)
public @interface DynamoDbSortKey {
}
