/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Document;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.internal.DefaultDocument;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DatabaseOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactGetItemsEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;

@SdkInternalApi
public class TransactGetItemsOperation
implements DatabaseOperation<TransactGetItemsRequest, TransactGetItemsResponse, List<Document>> {
    private TransactGetItemsEnhancedRequest request;

    private TransactGetItemsOperation(TransactGetItemsEnhancedRequest request) {
        this.request = request;
    }

    public static TransactGetItemsOperation create(TransactGetItemsEnhancedRequest request) {
        return new TransactGetItemsOperation(request);
    }

    @Override
    public TransactGetItemsRequest generateRequest(DynamoDbEnhancedClientExtension extension) {
        return (TransactGetItemsRequest)TransactGetItemsRequest.builder().transactItems(this.request.transactGetItems()).build();
    }

    @Override
    public Function<TransactGetItemsRequest, TransactGetItemsResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).transactGetItems(arg_0);
    }

    @Override
    public Function<TransactGetItemsRequest, CompletableFuture<TransactGetItemsResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).transactGetItems(arg_0);
    }

    @Override
    public List<Document> transformResponse(TransactGetItemsResponse response, DynamoDbEnhancedClientExtension extension) {
        return response.responses().stream().map(r -> r == null ? null : DefaultDocument.create(r.item())).collect(Collectors.toList());
    }
}

