/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dsql.model.DsqlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutClusterPolicyRequest
extends DsqlRequest
implements ToCopyableBuilder<Builder, PutClusterPolicyRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(PutClusterPolicyRequest.getter(PutClusterPolicyRequest::identifier)).setter(PutClusterPolicyRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(PutClusterPolicyRequest.getter(PutClusterPolicyRequest::policy)).setter(PutClusterPolicyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("bypassPolicyLockoutSafetyCheck").getter(PutClusterPolicyRequest.getter(PutClusterPolicyRequest::bypassPolicyLockoutSafetyCheck)).setter(PutClusterPolicyRequest.setter(Builder::bypassPolicyLockoutSafetyCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bypassPolicyLockoutSafetyCheck").build()}).build();
    private static final SdkField<String> EXPECTED_POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedPolicyVersion").getter(PutClusterPolicyRequest.getter(PutClusterPolicyRequest::expectedPolicyVersion)).setter(PutClusterPolicyRequest.setter(Builder::expectedPolicyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedPolicyVersion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(PutClusterPolicyRequest.getter(PutClusterPolicyRequest::clientToken)).setter(PutClusterPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD, EXPECTED_POLICY_VERSION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutClusterPolicyRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String policy;
    private final Boolean bypassPolicyLockoutSafetyCheck;
    private final String expectedPolicyVersion;
    private final String clientToken;

    private PutClusterPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
        this.expectedPolicyVersion = builder.expectedPolicyVersion;
        this.clientToken = builder.clientToken;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String policy() {
        return this.policy;
    }

    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public final String expectedPolicyVersion() {
        return this.expectedPolicyVersion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassPolicyLockoutSafetyCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedPolicyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutClusterPolicyRequest)) {
            return false;
        }
        PutClusterPolicyRequest other = (PutClusterPolicyRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck()) && Objects.equals(this.expectedPolicyVersion(), other.expectedPolicyVersion()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutClusterPolicyRequest").add("Identifier", (Object)this.identifier()).add("Policy", (Object)this.policy()).add("BypassPolicyLockoutSafetyCheck", (Object)this.bypassPolicyLockoutSafetyCheck()).add("ExpectedPolicyVersion", (Object)this.expectedPolicyVersion()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "bypassPolicyLockoutSafetyCheck": {
                return Optional.ofNullable(clazz.cast(this.bypassPolicyLockoutSafetyCheck()));
            }
            case "expectedPolicyVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedPolicyVersion()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("bypassPolicyLockoutSafetyCheck", BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD);
        map.put("expectedPolicyVersion", EXPECTED_POLICY_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutClusterPolicyRequest, T> g) {
        return obj -> g.apply((PutClusterPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String policy;
        private Boolean bypassPolicyLockoutSafetyCheck;
        private String expectedPolicyVersion;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutClusterPolicyRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.policy(model.policy);
            this.bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
            this.expectedPolicyVersion(model.expectedPolicyVersion);
            this.clientToken(model.clientToken);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final String getExpectedPolicyVersion() {
            return this.expectedPolicyVersion;
        }

        public final void setExpectedPolicyVersion(String expectedPolicyVersion) {
            this.expectedPolicyVersion = expectedPolicyVersion;
        }

        @Override
        public final Builder expectedPolicyVersion(String expectedPolicyVersion) {
            this.expectedPolicyVersion = expectedPolicyVersion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutClusterPolicyRequest build() {
            return new PutClusterPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DsqlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutClusterPolicyRequest> {
        public Builder identifier(String var1);

        public Builder policy(String var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);

        public Builder expectedPolicyVersion(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

