/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntriesCopier;
import software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntry;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSourceNetworkRecoveryRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, StartSourceNetworkRecoveryRequest> {
    private static final SdkField<Boolean> DEPLOY_AS_NEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deployAsNew").getter(StartSourceNetworkRecoveryRequest.getter(StartSourceNetworkRecoveryRequest::deployAsNew)).setter(StartSourceNetworkRecoveryRequest.setter(Builder::deployAsNew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployAsNew").build()}).build();
    private static final SdkField<List<StartSourceNetworkRecoveryRequestNetworkEntry>> SOURCE_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceNetworks").getter(StartSourceNetworkRecoveryRequest.getter(StartSourceNetworkRecoveryRequest::sourceNetworks)).setter(StartSourceNetworkRecoveryRequest.setter(Builder::sourceNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartSourceNetworkRecoveryRequestNetworkEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartSourceNetworkRecoveryRequest.getter(StartSourceNetworkRecoveryRequest::tags)).setter(StartSourceNetworkRecoveryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOY_AS_NEW_FIELD, SOURCE_NETWORKS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSourceNetworkRecoveryRequest.memberNameToFieldInitializer();
    private final Boolean deployAsNew;
    private final List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks;
    private final Map<String, String> tags;

    private StartSourceNetworkRecoveryRequest(BuilderImpl builder) {
        super(builder);
        this.deployAsNew = builder.deployAsNew;
        this.sourceNetworks = builder.sourceNetworks;
        this.tags = builder.tags;
    }

    public final Boolean deployAsNew() {
        return this.deployAsNew;
    }

    public final boolean hasSourceNetworks() {
        return this.sourceNetworks != null && !(this.sourceNetworks instanceof SdkAutoConstructList);
    }

    public final List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks() {
        return this.sourceNetworks;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deployAsNew());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceNetworks() ? this.sourceNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSourceNetworkRecoveryRequest)) {
            return false;
        }
        StartSourceNetworkRecoveryRequest other = (StartSourceNetworkRecoveryRequest)((Object)obj);
        return Objects.equals(this.deployAsNew(), other.deployAsNew()) && this.hasSourceNetworks() == other.hasSourceNetworks() && Objects.equals(this.sourceNetworks(), other.sourceNetworks()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartSourceNetworkRecoveryRequest").add("DeployAsNew", (Object)this.deployAsNew()).add("SourceNetworks", this.hasSourceNetworks() ? this.sourceNetworks() : null).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deployAsNew": {
                return Optional.ofNullable(clazz.cast(this.deployAsNew()));
            }
            case "sourceNetworks": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworks()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deployAsNew", DEPLOY_AS_NEW_FIELD);
        map.put("sourceNetworks", SOURCE_NETWORKS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSourceNetworkRecoveryRequest, T> g) {
        return obj -> g.apply((StartSourceNetworkRecoveryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private Boolean deployAsNew;
        private List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSourceNetworkRecoveryRequest model) {
            super(model);
            this.deployAsNew(model.deployAsNew);
            this.sourceNetworks(model.sourceNetworks);
            this.tags(model.tags);
        }

        public final Boolean getDeployAsNew() {
            return this.deployAsNew;
        }

        public final void setDeployAsNew(Boolean deployAsNew) {
            this.deployAsNew = deployAsNew;
        }

        @Override
        public final Builder deployAsNew(Boolean deployAsNew) {
            this.deployAsNew = deployAsNew;
            return this;
        }

        public final List<StartSourceNetworkRecoveryRequestNetworkEntry.Builder> getSourceNetworks() {
            List<StartSourceNetworkRecoveryRequestNetworkEntry.Builder> result = StartSourceNetworkRecoveryRequestNetworkEntriesCopier.copyToBuilder(this.sourceNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry.BuilderImpl> sourceNetworks) {
            this.sourceNetworks = StartSourceNetworkRecoveryRequestNetworkEntriesCopier.copyFromBuilder(sourceNetworks);
        }

        @Override
        public final Builder sourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks) {
            this.sourceNetworks = StartSourceNetworkRecoveryRequestNetworkEntriesCopier.copy(sourceNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworks(StartSourceNetworkRecoveryRequestNetworkEntry ... sourceNetworks) {
            this.sourceNetworks(Arrays.asList(sourceNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworks(Consumer<StartSourceNetworkRecoveryRequestNetworkEntry.Builder> ... sourceNetworks) {
            this.sourceNetworks(Stream.of(sourceNetworks).map(c -> (StartSourceNetworkRecoveryRequestNetworkEntry)((StartSourceNetworkRecoveryRequestNetworkEntry.Builder)StartSourceNetworkRecoveryRequestNetworkEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSourceNetworkRecoveryRequest build() {
            return new StartSourceNetworkRecoveryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSourceNetworkRecoveryRequest> {
        public Builder deployAsNew(Boolean var1);

        public Builder sourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry> var1);

        public Builder sourceNetworks(StartSourceNetworkRecoveryRequestNetworkEntry ... var1);

        public Builder sourceNetworks(Consumer<StartSourceNetworkRecoveryRequestNetworkEntry.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

