/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.ProductCodeMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductCode> {
    private static final SdkField<String> PRODUCT_CODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productCodeId").getter(ProductCode.getter(ProductCode::productCodeId)).setter(ProductCode.setter(Builder::productCodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodeId").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productCodeMode").getter(ProductCode.getter(ProductCode::productCodeModeAsString)).setter(ProductCode.setter(Builder::productCodeMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodeMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_ID_FIELD, PRODUCT_CODE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductCode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String productCodeId;
    private final String productCodeMode;

    private ProductCode(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeMode = builder.productCodeMode;
    }

    public final String productCodeId() {
        return this.productCodeId;
    }

    public final ProductCodeMode productCodeMode() {
        return ProductCodeMode.fromValue(this.productCodeMode);
    }

    public final String productCodeModeAsString() {
        return this.productCodeMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodeModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode)obj;
        return Objects.equals(this.productCodeId(), other.productCodeId()) && Objects.equals(this.productCodeModeAsString(), other.productCodeModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProductCode").add("ProductCodeId", (Object)this.productCodeId()).add("ProductCodeMode", (Object)this.productCodeModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "productCodeId": {
                return Optional.ofNullable(clazz.cast(this.productCodeId()));
            }
            case "productCodeMode": {
                return Optional.ofNullable(clazz.cast(this.productCodeModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("productCodeId", PRODUCT_CODE_ID_FIELD);
        map.put("productCodeMode", PRODUCT_CODE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductCode, T> g) {
        return obj -> g.apply((ProductCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productCodeId;
        private String productCodeMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            this.productCodeId(model.productCodeId);
            this.productCodeMode(model.productCodeMode);
        }

        public final String getProductCodeId() {
            return this.productCodeId;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final String getProductCodeMode() {
            return this.productCodeMode;
        }

        public final void setProductCodeMode(String productCodeMode) {
            this.productCodeMode = productCodeMode;
        }

        @Override
        public final Builder productCodeMode(String productCodeMode) {
            this.productCodeMode = productCodeMode;
            return this;
        }

        @Override
        public final Builder productCodeMode(ProductCodeMode productCodeMode) {
            this.productCodeMode(productCodeMode == null ? null : productCodeMode.toString());
            return this;
        }

        public ProductCode build() {
            return new ProductCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductCode> {
        public Builder productCodeId(String var1);

        public Builder productCodeMode(String var1);

        public Builder productCodeMode(ProductCodeMode var1);
    }
}

