/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DBInstance;
import software.amazon.awssdk.services.docdb.model.DBInstanceListCopier;
import software.amazon.awssdk.services.docdb.model.DocDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbInstancesResponse
extends DocDbResponse
implements ToCopyableBuilder<Builder, DescribeDbInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbInstancesResponse.getter(DescribeDbInstancesResponse::marker)).setter(DescribeDbInstancesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBInstance>> DB_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBInstances").getter(DescribeDbInstancesResponse.getter(DescribeDbInstancesResponse::dbInstances)).setter(DescribeDbInstancesResponse.setter(Builder::dbInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstances").build(), ListTrait.builder().memberLocationName("DBInstance").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstance").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_INSTANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDbInstancesResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<DBInstance> dbInstances;

    private DescribeDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbInstances = builder.dbInstances;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbInstances() {
        return this.dbInstances != null && !(this.dbInstances instanceof SdkAutoConstructList);
    }

    public final List<DBInstance> dbInstances() {
        return this.dbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbInstances() ? this.dbInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbInstancesResponse)) {
            return false;
        }
        DescribeDbInstancesResponse other = (DescribeDbInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbInstances() == other.hasDbInstances() && Objects.equals(this.dbInstances(), other.dbInstances());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbInstancesResponse").add("Marker", (Object)this.marker()).add("DBInstances", this.hasDbInstances() ? this.dbInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBInstances": {
                return Optional.ofNullable(clazz.cast(this.dbInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBInstances", DB_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeDbInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBInstance> dbInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbInstances(model.dbInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBInstance.Builder> getDbInstances() {
            List<DBInstance.Builder> result = DBInstanceListCopier.copyToBuilder(this.dbInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbInstances(Collection<DBInstance.BuilderImpl> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copyFromBuilder(dbInstances);
        }

        @Override
        public final Builder dbInstances(Collection<DBInstance> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copy(dbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(DBInstance ... dbInstances) {
            this.dbInstances(Arrays.asList(dbInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(Consumer<DBInstance.Builder> ... dbInstances) {
            this.dbInstances(Stream.of(dbInstances).map(c -> (DBInstance)((DBInstance.Builder)DBInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbInstancesResponse build() {
            return new DescribeDbInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DocDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbInstancesResponse> {
        public Builder marker(String var1);

        public Builder dbInstances(Collection<DBInstance> var1);

        public Builder dbInstances(DBInstance ... var1);

        public Builder dbInstances(Consumer<DBInstance.Builder> ... var1);
    }
}

