/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverGlobalClusterRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, FailoverGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterIdentifier").getter(FailoverGlobalClusterRequest.getter(FailoverGlobalClusterRequest::globalClusterIdentifier)).setter(FailoverGlobalClusterRequest.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDbClusterIdentifier").getter(FailoverGlobalClusterRequest.getter(FailoverGlobalClusterRequest::targetDbClusterIdentifier)).setter(FailoverGlobalClusterRequest.setter(Builder::targetDbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDbClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> ALLOW_DATA_LOSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowDataLoss").getter(FailoverGlobalClusterRequest.getter(FailoverGlobalClusterRequest::allowDataLoss)).setter(FailoverGlobalClusterRequest.setter(Builder::allowDataLoss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowDataLoss").build()}).build();
    private static final SdkField<Boolean> SWITCHOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Switchover").getter(FailoverGlobalClusterRequest.getter(FailoverGlobalClusterRequest::switchover)).setter(FailoverGlobalClusterRequest.setter(Builder::switchover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Switchover").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CLUSTER_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_IDENTIFIER_FIELD, ALLOW_DATA_LOSS_FIELD, SWITCHOVER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FailoverGlobalClusterRequest.memberNameToFieldInitializer();
    private final String globalClusterIdentifier;
    private final String targetDbClusterIdentifier;
    private final Boolean allowDataLoss;
    private final Boolean switchover;

    private FailoverGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.targetDbClusterIdentifier = builder.targetDbClusterIdentifier;
        this.allowDataLoss = builder.allowDataLoss;
        this.switchover = builder.switchover;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final String targetDbClusterIdentifier() {
        return this.targetDbClusterIdentifier;
    }

    public final Boolean allowDataLoss() {
        return this.allowDataLoss;
    }

    public final Boolean switchover() {
        return this.switchover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowDataLoss());
        hashCode = 31 * hashCode + Objects.hashCode(this.switchover());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverGlobalClusterRequest)) {
            return false;
        }
        FailoverGlobalClusterRequest other = (FailoverGlobalClusterRequest)((Object)obj);
        return Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && Objects.equals(this.targetDbClusterIdentifier(), other.targetDbClusterIdentifier()) && Objects.equals(this.allowDataLoss(), other.allowDataLoss()) && Objects.equals(this.switchover(), other.switchover());
    }

    public final String toString() {
        return ToString.builder((String)"FailoverGlobalClusterRequest").add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("TargetDbClusterIdentifier", (Object)this.targetDbClusterIdentifier()).add("AllowDataLoss", (Object)this.allowDataLoss()).add("Switchover", (Object)this.switchover()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "TargetDbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDbClusterIdentifier()));
            }
            case "AllowDataLoss": {
                return Optional.ofNullable(clazz.cast(this.allowDataLoss()));
            }
            case "Switchover": {
                return Optional.ofNullable(clazz.cast(this.switchover()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlobalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("TargetDbClusterIdentifier", TARGET_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("AllowDataLoss", ALLOW_DATA_LOSS_FIELD);
        map.put("Switchover", SWITCHOVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverGlobalClusterRequest, T> g) {
        return obj -> g.apply((FailoverGlobalClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String globalClusterIdentifier;
        private String targetDbClusterIdentifier;
        private Boolean allowDataLoss;
        private Boolean switchover;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverGlobalClusterRequest model) {
            super(model);
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.targetDbClusterIdentifier(model.targetDbClusterIdentifier);
            this.allowDataLoss(model.allowDataLoss);
            this.switchover(model.switchover);
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getTargetDbClusterIdentifier() {
            return this.targetDbClusterIdentifier;
        }

        public final void setTargetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
        }

        @Override
        public final Builder targetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
            return this;
        }

        public final Boolean getAllowDataLoss() {
            return this.allowDataLoss;
        }

        public final void setAllowDataLoss(Boolean allowDataLoss) {
            this.allowDataLoss = allowDataLoss;
        }

        @Override
        public final Builder allowDataLoss(Boolean allowDataLoss) {
            this.allowDataLoss = allowDataLoss;
            return this;
        }

        public final Boolean getSwitchover() {
            return this.switchover;
        }

        public final void setSwitchover(Boolean switchover) {
            this.switchover = switchover;
        }

        @Override
        public final Builder switchover(Boolean switchover) {
            this.switchover = switchover;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FailoverGlobalClusterRequest build() {
            return new FailoverGlobalClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, FailoverGlobalClusterRequest> {
        public Builder globalClusterIdentifier(String var1);

        public Builder targetDbClusterIdentifier(String var1);

        public Builder allowDataLoss(Boolean var1);

        public Builder switchover(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

