/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBInstance implements SdkPojo, Serializable, ToCopyableBuilder<DBInstance.Builder, DBInstance> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DBInstance::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(DBInstance::dbInstanceClass)).setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DBInstance::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> DB_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceStatus").getter(getter(DBInstance::dbInstanceStatus))
            .setter(setter(Builder::dbInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceStatus").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Endpoint").getter(getter(DBInstance::endpoint)).setter(setter(Builder::endpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InstanceCreateTime").getter(getter(DBInstance::instanceCreateTime))
            .setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(DBInstance::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(DBInstance::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(DBInstance::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupMembership")
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupMembership").build()).build()).build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DBInstance::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<DBSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField
            .<DBSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("DBSubnetGroup")
            .getter(getter(DBInstance::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup)).constructor(DBSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(DBInstance::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<PendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(DBInstance::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(PendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestRestorableTime").getter(getter(DBInstance::latestRestorableTime))
            .setter(setter(Builder::latestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build())
            .build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DBInstance::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(DBInstance::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(DBInstance::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<List<DBInstanceStatusInfo>> STATUS_INFOS_FIELD = SdkField
            .<List<DBInstanceStatusInfo>> builder(MarshallingType.LIST)
            .memberName("StatusInfos")
            .getter(getter(DBInstance::statusInfos))
            .setter(setter(Builder::statusInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBInstanceStatusInfo")
                            .memberFieldInfo(
                                    SdkField.<DBInstanceStatusInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBInstanceStatusInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBInstanceStatusInfo").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DBInstance::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(DBInstance::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DBInstance::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(DBInstance::dbiResourceId)).setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(DBInstance::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(DBInstance::promotionTier)).setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceArn").getter(getter(DBInstance::dbInstanceArn)).setter(setter(Builder::dbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()).build();

    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledCloudwatchLogsExports")
            .getter(getter(DBInstance::enabledCloudwatchLogsExports))
            .setter(setter(Builder::enabledCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, DB_INSTANCE_STATUS_FIELD, ENDPOINT_FIELD, INSTANCE_CREATE_TIME_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, BACKUP_RETENTION_PERIOD_FIELD, VPC_SECURITY_GROUPS_FIELD, AVAILABILITY_ZONE_FIELD,
            DB_SUBNET_GROUP_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD,
            LATEST_RESTORABLE_TIME_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            STATUS_INFOS_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DBI_RESOURCE_ID_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, PROMOTION_TIER_FIELD, DB_INSTANCE_ARN_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbInstanceIdentifier;

    private final String dbInstanceClass;

    private final String engine;

    private final String dbInstanceStatus;

    private final Endpoint endpoint;

    private final Instant instanceCreateTime;

    private final String preferredBackupWindow;

    private final Integer backupRetentionPeriod;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;

    private final String availabilityZone;

    private final DBSubnetGroup dbSubnetGroup;

    private final String preferredMaintenanceWindow;

    private final PendingModifiedValues pendingModifiedValues;

    private final Instant latestRestorableTime;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final Boolean publiclyAccessible;

    private final List<DBInstanceStatusInfo> statusInfos;

    private final String dbClusterIdentifier;

    private final Boolean storageEncrypted;

    private final String kmsKeyId;

    private final String dbiResourceId;

    private final String caCertificateIdentifier;

    private final Integer promotionTier;

    private final String dbInstanceArn;

    private final List<String> enabledCloudwatchLogsExports;

    private DBInstance(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.dbInstanceStatus = builder.dbInstanceStatus;
        this.endpoint = builder.endpoint;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.statusInfos = builder.statusInfos;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbiResourceId = builder.dbiResourceId;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.promotionTier = builder.promotionTier;
        this.dbInstanceArn = builder.dbInstanceArn;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
    }

    /**
     * <p>
     * Contains a user-provided database identifier. This identifier is the unique key that identifies an instance.
     * </p>
     * 
     * @return Contains a user-provided database identifier. This identifier is the unique key that identifies an
     *         instance.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Contains the name of the compute and memory capacity class of the instance.
     * </p>
     * 
     * @return Contains the name of the compute and memory capacity class of the instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Provides the name of the database engine to be used for this instance.
     * </p>
     * 
     * @return Provides the name of the database engine to be used for this instance.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Specifies the current state of this database.
     * </p>
     * 
     * @return Specifies the current state of this database.
     */
    public final String dbInstanceStatus() {
        return dbInstanceStatus;
    }

    /**
     * <p>
     * Specifies the connection endpoint.
     * </p>
     * 
     * @return Specifies the connection endpoint.
     */
    public final Endpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Provides the date and time that the instance was created.
     * </p>
     * 
     * @return Provides the date and time that the instance was created.
     */
    public final Instant instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as
     * determined by the <code>BackupRetentionPeriod</code>.
     * </p>
     * 
     * @return Specifies the daily time range during which automated backups are created if automated backups are
     *         enabled, as determined by the <code>BackupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * Specifies the number of days for which automatic snapshots are retained.
     * </p>
     * 
     * @return Specifies the number of days for which automatic snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of VPC security group elements that the instance belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return Provides a list of VPC security group elements that the instance belongs to.
     */
    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * Specifies the name of the Availability Zone that the instance is located in.
     * </p>
     * 
     * @return Specifies the name of the Availability Zone that the instance is located in.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Specifies information on the subnet group that is associated with the instance, including the name, description,
     * and subnets in the subnet group.
     * </p>
     * 
     * @return Specifies information on the subnet group that is associated with the instance, including the name,
     *         description, and subnets in the subnet group.
     */
    public final DBSubnetGroup dbSubnetGroup() {
        return dbSubnetGroup;
    }

    /**
     * <p>
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
     *         (UTC).
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies that changes to the instance are pending. This element is included only when changes are pending.
     * Specific changes are identified by subelements.
     * </p>
     * 
     * @return Specifies that changes to the instance are pending. This element is included only when changes are
     *         pending. Specific changes are identified by subelements.
     */
    public final PendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     * </p>
     * 
     * @return Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public final Instant latestRestorableTime() {
        return latestRestorableTime;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor
     * version upgrades regardless of the value set.
     * </p>
     * 
     * @return Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform
     *         minor version upgrades regardless of the value set.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Not supported. Amazon DocumentDB does not currently support public endpoints. The value of
     * <code>PubliclyAccessible</code> is always <code>false</code>.
     * </p>
     * 
     * @return Not supported. Amazon DocumentDB does not currently support public endpoints. The value of
     *         <code>PubliclyAccessible</code> is always <code>false</code>.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusInfos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusInfos() {
        return statusInfos != null && !(statusInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of a read replica. If the instance is not a read replica, this is blank.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusInfos} method.
     * </p>
     * 
     * @return The status of a read replica. If the instance is not a read replica, this is blank.
     */
    public final List<DBInstanceStatusInfo> statusInfos() {
        return statusInfos;
    }

    /**
     * <p>
     * Contains the name of the cluster that the instance is a member of if the instance is a member of a cluster.
     * </p>
     * 
     * @return Contains the name of the cluster that the instance is a member of if the instance is a member of a
     *         cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Specifies whether or not the instance is encrypted.
     * </p>
     * 
     * @return Specifies whether or not the instance is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted instance.
     * </p>
     * 
     * @return If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted instance.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries
     * whenever the KMS key for the instance is accessed.
     * </p>
     * 
     * @return The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log
     *         entries whenever the KMS key for the instance is accessed.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The identifier of the CA certificate for this DB instance.
     * </p>
     * 
     * @return The identifier of the CA certificate for this DB instance.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after
     * a failure of the existing primary instance.
     * </p>
     * 
     * @return A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary
     *         instance after a failure of the existing primary instance.
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the instance.
     */
    public final String dbInstanceArn() {
        return dbInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports != null && !(enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that this instance is configured to export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledCloudwatchLogsExports} method.
     * </p>
     * 
     * @return A list of log types that this instance is configured to export to CloudWatch Logs.
     */
    public final List<String> enabledCloudwatchLogsExports() {
        return enabledCloudwatchLogsExports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusInfos() ? statusInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(engine(), other.engine())
                && Objects.equals(dbInstanceStatus(), other.dbInstanceStatus()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dbSubnetGroup(), other.dbSubnetGroup())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(latestRestorableTime(), other.latestRestorableTime())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasStatusInfos() == other.hasStatusInfos()
                && Objects.equals(statusInfos(), other.statusInfos())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(storageEncrypted(), other.storageEncrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dbiResourceId(), other.dbiResourceId())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(promotionTier(), other.promotionTier())
                && Objects.equals(dbInstanceArn(), other.dbInstanceArn())
                && hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports()
                && Objects.equals(enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBInstance").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("DBInstanceClass", dbInstanceClass()).add("Engine", engine()).add("DBInstanceStatus", dbInstanceStatus())
                .add("Endpoint", endpoint()).add("InstanceCreateTime", instanceCreateTime())
                .add("PreferredBackupWindow", preferredBackupWindow()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("AvailabilityZone", availabilityZone()).add("DBSubnetGroup", dbSubnetGroup())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PendingModifiedValues", pendingModifiedValues()).add("LatestRestorableTime", latestRestorableTime())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("PubliclyAccessible", publiclyAccessible()).add("StatusInfos", hasStatusInfos() ? statusInfos() : null)
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("StorageEncrypted", storageEncrypted())
                .add("KmsKeyId", kmsKeyId()).add("DbiResourceId", dbiResourceId())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("PromotionTier", promotionTier())
                .add("DBInstanceArn", dbInstanceArn())
                .add("EnabledCloudwatchLogsExports", hasEnabledCloudwatchLogsExports() ? enabledCloudwatchLogsExports() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "DBInstanceStatus":
            return Optional.ofNullable(clazz.cast(dbInstanceStatus()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DBSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "LatestRestorableTime":
            return Optional.ofNullable(clazz.cast(latestRestorableTime()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "StatusInfos":
            return Optional.ofNullable(clazz.cast(statusInfos()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "DBInstanceArn":
            return Optional.ofNullable(clazz.cast(dbInstanceArn()));
        case "EnabledCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enabledCloudwatchLogsExports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstance, T> g) {
        return obj -> g.apply((DBInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBInstance> {
        /**
         * <p>
         * Contains a user-provided database identifier. This identifier is the unique key that identifies an instance.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        Contains a user-provided database identifier. This identifier is the unique key that identifies an
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Contains the name of the compute and memory capacity class of the instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        Contains the name of the compute and memory capacity class of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Provides the name of the database engine to be used for this instance.
         * </p>
         * 
         * @param engine
         *        Provides the name of the database engine to be used for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Specifies the current state of this database.
         * </p>
         * 
         * @param dbInstanceStatus
         *        Specifies the current state of this database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceStatus(String dbInstanceStatus);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * 
         * @param endpoint
         *        Specifies the connection endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * Provides the date and time that the instance was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        Provides the date and time that the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(Instant instanceCreateTime);

        /**
         * <p>
         * Specifies the daily time range during which automated backups are created if automated backups are enabled,
         * as determined by the <code>BackupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        Specifies the daily time range during which automated backups are created if automated backups are
         *        enabled, as determined by the <code>BackupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * Specifies the number of days for which automatic snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        Specifies the number of days for which automatic snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * Provides a list of VPC security group elements that the instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of VPC security group elements that the instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security group elements that the instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        Provides a list of VPC security group elements that the instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups);

        /**
         * <p>
         * Provides a list of VPC security group elements that the instance belongs to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<VpcSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcSecurityGroups(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on {@link List<VpcSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(List<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Specifies the name of the Availability Zone that the instance is located in.
         * </p>
         * 
         * @param availabilityZone
         *        Specifies the name of the Availability Zone that the instance is located in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Specifies information on the subnet group that is associated with the instance, including the name,
         * description, and subnets in the subnet group.
         * </p>
         * 
         * @param dbSubnetGroup
         *        Specifies information on the subnet group that is associated with the instance, including the name,
         *        description, and subnets in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup);

        /**
         * <p>
         * Specifies information on the subnet group that is associated with the instance, including the name,
         * description, and subnets in the subnet group.
         * </p>
         * This is a convenience that creates an instance of the {@link DBSubnetGroup.Builder} avoiding the need to
         * create one manually via {@link DBSubnetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBSubnetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #dbSubnetGroup(DBSubnetGroup)}.
         * 
         * @param dbSubnetGroup
         *        a consumer that will call methods on {@link DBSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroup(DBSubnetGroup)
         */
        default Builder dbSubnetGroup(Consumer<DBSubnetGroup.Builder> dbSubnetGroup) {
            return dbSubnetGroup(DBSubnetGroup.builder().applyMutation(dbSubnetGroup).build());
        }

        /**
         * <p>
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time
         * (UTC).
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies that changes to the instance are pending. This element is included only when changes are pending.
         * Specific changes are identified by subelements.
         * </p>
         * 
         * @param pendingModifiedValues
         *        Specifies that changes to the instance are pending. This element is included only when changes are
         *        pending. Specific changes are identified by subelements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * Specifies that changes to the instance are pending. This element is included only when changes are pending.
         * Specific changes are identified by subelements.
         * </p>
         * This is a convenience that creates an instance of the {@link PendingModifiedValues.Builder} avoiding the need
         * to create one manually via {@link PendingModifiedValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link PendingModifiedValues.Builder#build()} is called immediately and
         * its result is passed to {@link #pendingModifiedValues(PendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link PendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(PendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(PendingModifiedValues.builder().applyMutation(pendingModifiedValues).build());
        }

        /**
         * <p>
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         * </p>
         * 
         * @param latestRestorableTime
         *        Specifies the latest time to which a database can be restored with point-in-time restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableTime(Instant latestRestorableTime);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor
         * version upgrades regardless of the value set.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform
         *        minor version upgrades regardless of the value set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Not supported. Amazon DocumentDB does not currently support public endpoints. The value of
         * <code>PubliclyAccessible</code> is always <code>false</code>.
         * </p>
         * 
         * @param publiclyAccessible
         *        Not supported. Amazon DocumentDB does not currently support public endpoints. The value of
         *        <code>PubliclyAccessible</code> is always <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The status of a read replica. If the instance is not a read replica, this is blank.
         * </p>
         * 
         * @param statusInfos
         *        The status of a read replica. If the instance is not a read replica, this is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos);

        /**
         * <p>
         * The status of a read replica. If the instance is not a read replica, this is blank.
         * </p>
         * 
         * @param statusInfos
         *        The status of a read replica. If the instance is not a read replica, this is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInfos(DBInstanceStatusInfo... statusInfos);

        /**
         * <p>
         * The status of a read replica. If the instance is not a read replica, this is blank.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBInstanceStatusInfo>.Builder} avoiding the
         * need to create one manually via {@link List<DBInstanceStatusInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBInstanceStatusInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #statusInfos(List<DBInstanceStatusInfo>)}.
         * 
         * @param statusInfos
         *        a consumer that will call methods on {@link List<DBInstanceStatusInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusInfos(List<DBInstanceStatusInfo>)
         */
        Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder>... statusInfos);

        /**
         * <p>
         * Contains the name of the cluster that the instance is a member of if the instance is a member of a cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        Contains the name of the cluster that the instance is a member of if the instance is a member of a
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Specifies whether or not the instance is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether or not the instance is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted instance.
         * </p>
         * 
         * @param kmsKeyId
         *        If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries
         * whenever the KMS key for the instance is accessed.
         * </p>
         * 
         * @param dbiResourceId
         *        The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log
         *        entries whenever the KMS key for the instance is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The identifier of the CA certificate for this DB instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The identifier of the CA certificate for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance
         * after a failure of the existing primary instance.
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary
         *        instance after a failure of the existing primary instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the instance.
         * </p>
         * 
         * @param dbInstanceArn
         *        The Amazon Resource Name (ARN) for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceArn(String dbInstanceArn);

        /**
         * <p>
         * A list of log types that this instance is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this instance is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports);

        /**
         * <p>
         * A list of log types that this instance is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudwatchLogsExports
         *        A list of log types that this instance is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports);
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String dbInstanceClass;

        private String engine;

        private String dbInstanceStatus;

        private Endpoint endpoint;

        private Instant instanceCreateTime;

        private String preferredBackupWindow;

        private Integer backupRetentionPeriod;

        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private DBSubnetGroup dbSubnetGroup;

        private String preferredMaintenanceWindow;

        private PendingModifiedValues pendingModifiedValues;

        private Instant latestRestorableTime;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private Boolean publiclyAccessible;

        private List<DBInstanceStatusInfo> statusInfos = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterIdentifier;

        private Boolean storageEncrypted;

        private String kmsKeyId;

        private String dbiResourceId;

        private String caCertificateIdentifier;

        private Integer promotionTier;

        private String dbInstanceArn;

        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstance model) {
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbInstanceClass(model.dbInstanceClass);
            engine(model.engine);
            dbInstanceStatus(model.dbInstanceStatus);
            endpoint(model.endpoint);
            instanceCreateTime(model.instanceCreateTime);
            preferredBackupWindow(model.preferredBackupWindow);
            backupRetentionPeriod(model.backupRetentionPeriod);
            vpcSecurityGroups(model.vpcSecurityGroups);
            availabilityZone(model.availabilityZone);
            dbSubnetGroup(model.dbSubnetGroup);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            pendingModifiedValues(model.pendingModifiedValues);
            latestRestorableTime(model.latestRestorableTime);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            publiclyAccessible(model.publiclyAccessible);
            statusInfos(model.statusInfos);
            dbClusterIdentifier(model.dbClusterIdentifier);
            storageEncrypted(model.storageEncrypted);
            kmsKeyId(model.kmsKeyId);
            dbiResourceId(model.dbiResourceId);
            caCertificateIdentifier(model.caCertificateIdentifier);
            promotionTier(model.promotionTier);
            dbInstanceArn(model.dbInstanceArn);
            enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        @Transient
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getDbInstanceStatus() {
            return dbInstanceStatus;
        }

        public final void setDbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
        }

        @Override
        @Transient
        public final Builder dbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getInstanceCreateTime() {
            return instanceCreateTime;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        @Transient
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        @Transient
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        @Transient
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final DBSubnetGroup.Builder getDbSubnetGroup() {
            return dbSubnetGroup != null ? dbSubnetGroup.toBuilder() : null;
        }

        public final void setDbSubnetGroup(DBSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        @Transient
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        @Transient
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final Instant getLatestRestorableTime() {
            return latestRestorableTime;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        @Override
        @Transient
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        @Transient
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<DBInstanceStatusInfo.Builder> getStatusInfos() {
            List<DBInstanceStatusInfo.Builder> result = DBInstanceStatusInfoListCopier.copyToBuilder(this.statusInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusInfos(Collection<DBInstanceStatusInfo.BuilderImpl> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copyFromBuilder(statusInfos);
        }

        @Override
        @Transient
        public final Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copy(statusInfos);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statusInfos(DBInstanceStatusInfo... statusInfos) {
            statusInfos(Arrays.asList(statusInfos));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder>... statusInfos) {
            statusInfos(Stream.of(statusInfos).map(c -> DBInstanceStatusInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        @Transient
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        @Transient
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        @Transient
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        @Transient
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final String getDbInstanceArn() {
            return dbInstanceArn;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        @Override
        @Transient
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledCloudwatchLogsExports;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        @Override
        @Transient
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports) {
            enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        @Override
        public DBInstance build() {
            return new DBInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
