/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.Action;
import software.amazon.awssdk.services.dlm.model.ActionListCopier;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyTargetListCopier;
import software.amazon.awssdk.services.dlm.model.EventSource;
import software.amazon.awssdk.services.dlm.model.Exclusions;
import software.amazon.awssdk.services.dlm.model.Parameters;
import software.amazon.awssdk.services.dlm.model.PolicyLanguageValues;
import software.amazon.awssdk.services.dlm.model.PolicyTypeValues;
import software.amazon.awssdk.services.dlm.model.ResourceLocationListCopier;
import software.amazon.awssdk.services.dlm.model.ResourceLocationValues;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValues;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValuesListCopier;
import software.amazon.awssdk.services.dlm.model.Schedule;
import software.amazon.awssdk.services.dlm.model.ScheduleListCopier;
import software.amazon.awssdk.services.dlm.model.Tag;
import software.amazon.awssdk.services.dlm.model.TargetTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyDetails> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(PolicyDetails.getter(PolicyDetails::policyTypeAsString)).setter(PolicyDetails.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(PolicyDetails.getter(PolicyDetails::resourceTypesAsStrings)).setter(PolicyDetails.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceLocations").getter(PolicyDetails.getter(PolicyDetails::resourceLocationsAsStrings)).setter(PolicyDetails.setter(Builder::resourceLocationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TARGET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetTags").getter(PolicyDetails.getter(PolicyDetails::targetTags)).setter(PolicyDetails.setter(Builder::targetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Schedule>> SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Schedules").getter(PolicyDetails.getter(PolicyDetails::schedules)).setter(PolicyDetails.setter(Builder::schedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parameters").getter(PolicyDetails.getter(PolicyDetails::parameters)).setter(PolicyDetails.setter(Builder::parameters)).constructor(Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<EventSource> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventSource").getter(PolicyDetails.getter(PolicyDetails::eventSource)).setter(PolicyDetails.setter(Builder::eventSource)).constructor(EventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(PolicyDetails.getter(PolicyDetails::actions)).setter(PolicyDetails.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyLanguage").getter(PolicyDetails.getter(PolicyDetails::policyLanguageAsString)).setter(PolicyDetails.setter(Builder::policyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyLanguage").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(PolicyDetails.getter(PolicyDetails::resourceTypeAsString)).setter(PolicyDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Integer> CREATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CreateInterval").getter(PolicyDetails.getter(PolicyDetails::createInterval)).setter(PolicyDetails.setter(Builder::createInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateInterval").build()}).build();
    private static final SdkField<Integer> RETAIN_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetainInterval").getter(PolicyDetails.getter(PolicyDetails::retainInterval)).setter(PolicyDetails.setter(Builder::retainInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainInterval").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(PolicyDetails.getter(PolicyDetails::copyTags)).setter(PolicyDetails.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<List<CrossRegionCopyTarget>> CROSS_REGION_COPY_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossRegionCopyTargets").getter(PolicyDetails.getter(PolicyDetails::crossRegionCopyTargets)).setter(PolicyDetails.setter(Builder::crossRegionCopyTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopyTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossRegionCopyTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EXTEND_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExtendDeletion").getter(PolicyDetails.getter(PolicyDetails::extendDeletion)).setter(PolicyDetails.setter(Builder::extendDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendDeletion").build()}).build();
    private static final SdkField<Exclusions> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclusions").getter(PolicyDetails.getter(PolicyDetails::exclusions)).setter(PolicyDetails.setter(Builder::exclusions)).constructor(Exclusions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD, RESOURCE_TYPES_FIELD, RESOURCE_LOCATIONS_FIELD, TARGET_TAGS_FIELD, SCHEDULES_FIELD, PARAMETERS_FIELD, EVENT_SOURCE_FIELD, ACTIONS_FIELD, POLICY_LANGUAGE_FIELD, RESOURCE_TYPE_FIELD, CREATE_INTERVAL_FIELD, RETAIN_INTERVAL_FIELD, COPY_TAGS_FIELD, CROSS_REGION_COPY_TARGETS_FIELD, EXTEND_DELETION_FIELD, EXCLUSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyType;
    private final List<String> resourceTypes;
    private final List<String> resourceLocations;
    private final List<Tag> targetTags;
    private final List<Schedule> schedules;
    private final Parameters parameters;
    private final EventSource eventSource;
    private final List<Action> actions;
    private final String policyLanguage;
    private final String resourceType;
    private final Integer createInterval;
    private final Integer retainInterval;
    private final Boolean copyTags;
    private final List<CrossRegionCopyTarget> crossRegionCopyTargets;
    private final Boolean extendDeletion;
    private final Exclusions exclusions;

    private PolicyDetails(BuilderImpl builder) {
        this.policyType = builder.policyType;
        this.resourceTypes = builder.resourceTypes;
        this.resourceLocations = builder.resourceLocations;
        this.targetTags = builder.targetTags;
        this.schedules = builder.schedules;
        this.parameters = builder.parameters;
        this.eventSource = builder.eventSource;
        this.actions = builder.actions;
        this.policyLanguage = builder.policyLanguage;
        this.resourceType = builder.resourceType;
        this.createInterval = builder.createInterval;
        this.retainInterval = builder.retainInterval;
        this.copyTags = builder.copyTags;
        this.crossRegionCopyTargets = builder.crossRegionCopyTargets;
        this.extendDeletion = builder.extendDeletion;
        this.exclusions = builder.exclusions;
    }

    public final PolicyTypeValues policyType() {
        return PolicyTypeValues.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final List<ResourceTypeValues> resourceTypes() {
        return ResourceTypeValuesListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final List<ResourceLocationValues> resourceLocations() {
        return ResourceLocationListCopier.copyStringToEnum(this.resourceLocations);
    }

    public final boolean hasResourceLocations() {
        return this.resourceLocations != null && !(this.resourceLocations instanceof SdkAutoConstructList);
    }

    public final List<String> resourceLocationsAsStrings() {
        return this.resourceLocations;
    }

    public final boolean hasTargetTags() {
        return this.targetTags != null && !(this.targetTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> targetTags() {
        return this.targetTags;
    }

    public final boolean hasSchedules() {
        return this.schedules != null && !(this.schedules instanceof SdkAutoConstructList);
    }

    public final List<Schedule> schedules() {
        return this.schedules;
    }

    public final Parameters parameters() {
        return this.parameters;
    }

    public final EventSource eventSource() {
        return this.eventSource;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<Action> actions() {
        return this.actions;
    }

    public final PolicyLanguageValues policyLanguage() {
        return PolicyLanguageValues.fromValue(this.policyLanguage);
    }

    public final String policyLanguageAsString() {
        return this.policyLanguage;
    }

    public final ResourceTypeValues resourceType() {
        return ResourceTypeValues.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Integer createInterval() {
        return this.createInterval;
    }

    public final Integer retainInterval() {
        return this.retainInterval;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final boolean hasCrossRegionCopyTargets() {
        return this.crossRegionCopyTargets != null && !(this.crossRegionCopyTargets instanceof SdkAutoConstructList);
    }

    public final List<CrossRegionCopyTarget> crossRegionCopyTargets() {
        return this.crossRegionCopyTargets;
    }

    public final Boolean extendDeletion() {
        return this.extendDeletion;
    }

    public final Exclusions exclusions() {
        return this.exclusions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceLocations() ? this.resourceLocationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetTags() ? this.targetTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchedules() ? this.schedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionCopyTargets() ? this.crossRegionCopyTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.extendDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails)obj;
        return Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && this.hasResourceLocations() == other.hasResourceLocations() && Objects.equals(this.resourceLocationsAsStrings(), other.resourceLocationsAsStrings()) && this.hasTargetTags() == other.hasTargetTags() && Objects.equals(this.targetTags(), other.targetTags()) && this.hasSchedules() == other.hasSchedules() && Objects.equals(this.schedules(), other.schedules()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.eventSource(), other.eventSource()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.policyLanguageAsString(), other.policyLanguageAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.createInterval(), other.createInterval()) && Objects.equals(this.retainInterval(), other.retainInterval()) && Objects.equals(this.copyTags(), other.copyTags()) && this.hasCrossRegionCopyTargets() == other.hasCrossRegionCopyTargets() && Objects.equals(this.crossRegionCopyTargets(), other.crossRegionCopyTargets()) && Objects.equals(this.extendDeletion(), other.extendDeletion()) && Objects.equals(this.exclusions(), other.exclusions());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyDetails").add("PolicyType", (Object)this.policyTypeAsString()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("ResourceLocations", this.hasResourceLocations() ? this.resourceLocationsAsStrings() : null).add("TargetTags", this.hasTargetTags() ? this.targetTags() : null).add("Schedules", this.hasSchedules() ? this.schedules() : null).add("Parameters", (Object)this.parameters()).add("EventSource", (Object)this.eventSource()).add("Actions", this.hasActions() ? this.actions() : null).add("PolicyLanguage", (Object)this.policyLanguageAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("CreateInterval", (Object)this.createInterval()).add("RetainInterval", (Object)this.retainInterval()).add("CopyTags", (Object)this.copyTags()).add("CrossRegionCopyTargets", this.hasCrossRegionCopyTargets() ? this.crossRegionCopyTargets() : null).add("ExtendDeletion", (Object)this.extendDeletion()).add("Exclusions", (Object)this.exclusions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "ResourceLocations": {
                return Optional.ofNullable(clazz.cast(this.resourceLocationsAsStrings()));
            }
            case "TargetTags": {
                return Optional.ofNullable(clazz.cast(this.targetTags()));
            }
            case "Schedules": {
                return Optional.ofNullable(clazz.cast(this.schedules()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "PolicyLanguage": {
                return Optional.ofNullable(clazz.cast(this.policyLanguageAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "CreateInterval": {
                return Optional.ofNullable(clazz.cast(this.createInterval()));
            }
            case "RetainInterval": {
                return Optional.ofNullable(clazz.cast(this.retainInterval()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "CrossRegionCopyTargets": {
                return Optional.ofNullable(clazz.cast(this.crossRegionCopyTargets()));
            }
            case "ExtendDeletion": {
                return Optional.ofNullable(clazz.cast(this.extendDeletion()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("ResourceLocations", RESOURCE_LOCATIONS_FIELD);
        map.put("TargetTags", TARGET_TAGS_FIELD);
        map.put("Schedules", SCHEDULES_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("EventSource", EVENT_SOURCE_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("PolicyLanguage", POLICY_LANGUAGE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("CreateInterval", CREATE_INTERVAL_FIELD);
        map.put("RetainInterval", RETAIN_INTERVAL_FIELD);
        map.put("CopyTags", COPY_TAGS_FIELD);
        map.put("CrossRegionCopyTargets", CROSS_REGION_COPY_TARGETS_FIELD);
        map.put("ExtendDeletion", EXTEND_DELETION_FIELD);
        map.put("Exclusions", EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyDetails, T> g) {
        return obj -> g.apply((PolicyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyType;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceLocations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> targetTags = DefaultSdkAutoConstructList.getInstance();
        private List<Schedule> schedules = DefaultSdkAutoConstructList.getInstance();
        private Parameters parameters;
        private EventSource eventSource;
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private String policyLanguage;
        private String resourceType;
        private Integer createInterval;
        private Integer retainInterval;
        private Boolean copyTags;
        private List<CrossRegionCopyTarget> crossRegionCopyTargets = DefaultSdkAutoConstructList.getInstance();
        private Boolean extendDeletion;
        private Exclusions exclusions;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDetails model) {
            this.policyType(model.policyType);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.resourceLocationsWithStrings(model.resourceLocations);
            this.targetTags(model.targetTags);
            this.schedules(model.schedules);
            this.parameters(model.parameters);
            this.eventSource(model.eventSource);
            this.actions(model.actions);
            this.policyLanguage(model.policyLanguage);
            this.resourceType(model.resourceType);
            this.createInterval(model.createInterval);
            this.retainInterval(model.retainInterval);
            this.copyTags(model.copyTags);
            this.crossRegionCopyTargets(model.crossRegionCopyTargets);
            this.extendDeletion(model.extendDeletion);
            this.exclusions(model.exclusions);
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyTypeValues policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeValues ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getResourceLocations() {
            if (this.resourceLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceLocations;
        }

        public final void setResourceLocations(Collection<String> resourceLocations) {
            this.resourceLocations = ResourceLocationListCopier.copy(resourceLocations);
        }

        @Override
        public final Builder resourceLocationsWithStrings(Collection<String> resourceLocations) {
            this.resourceLocations = ResourceLocationListCopier.copy(resourceLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLocationsWithStrings(String ... resourceLocations) {
            this.resourceLocationsWithStrings(Arrays.asList(resourceLocations));
            return this;
        }

        @Override
        public final Builder resourceLocations(Collection<ResourceLocationValues> resourceLocations) {
            this.resourceLocations = ResourceLocationListCopier.copyEnumToString(resourceLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLocations(ResourceLocationValues ... resourceLocations) {
            this.resourceLocations(Arrays.asList(resourceLocations));
            return this;
        }

        public final List<Tag.Builder> getTargetTags() {
            List<Tag.Builder> result = TargetTagListCopier.copyToBuilder(this.targetTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetTags(Collection<Tag.BuilderImpl> targetTags) {
            this.targetTags = TargetTagListCopier.copyFromBuilder(targetTags);
        }

        @Override
        public final Builder targetTags(Collection<Tag> targetTags) {
            this.targetTags = TargetTagListCopier.copy(targetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(Tag ... targetTags) {
            this.targetTags(Arrays.asList(targetTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(Consumer<Tag.Builder> ... targetTags) {
            this.targetTags(Stream.of(targetTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Schedule.Builder> getSchedules() {
            List<Schedule.Builder> result = ScheduleListCopier.copyToBuilder(this.schedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedules(Collection<Schedule.BuilderImpl> schedules) {
            this.schedules = ScheduleListCopier.copyFromBuilder(schedules);
        }

        @Override
        public final Builder schedules(Collection<Schedule> schedules) {
            this.schedules = ScheduleListCopier.copy(schedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Schedule ... schedules) {
            this.schedules(Arrays.asList(schedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Consumer<Schedule.Builder> ... schedules) {
            this.schedules(Stream.of(schedules).map(c -> (Schedule)((Schedule.Builder)Schedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Parameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final EventSource.Builder getEventSource() {
            return this.eventSource != null ? this.eventSource.toBuilder() : null;
        }

        public final void setEventSource(EventSource.BuilderImpl eventSource) {
            this.eventSource = eventSource != null ? eventSource.build() : null;
        }

        @Override
        public final Builder eventSource(EventSource eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPolicyLanguage() {
            return this.policyLanguage;
        }

        public final void setPolicyLanguage(String policyLanguage) {
            this.policyLanguage = policyLanguage;
        }

        @Override
        public final Builder policyLanguage(String policyLanguage) {
            this.policyLanguage = policyLanguage;
            return this;
        }

        @Override
        public final Builder policyLanguage(PolicyLanguageValues policyLanguage) {
            this.policyLanguage(policyLanguage == null ? null : policyLanguage.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceTypeValues resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getCreateInterval() {
            return this.createInterval;
        }

        public final void setCreateInterval(Integer createInterval) {
            this.createInterval = createInterval;
        }

        @Override
        public final Builder createInterval(Integer createInterval) {
            this.createInterval = createInterval;
            return this;
        }

        public final Integer getRetainInterval() {
            return this.retainInterval;
        }

        public final void setRetainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
        }

        @Override
        public final Builder retainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final List<CrossRegionCopyTarget.Builder> getCrossRegionCopyTargets() {
            List<CrossRegionCopyTarget.Builder> result = CrossRegionCopyTargetListCopier.copyToBuilder(this.crossRegionCopyTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionCopyTargets(Collection<CrossRegionCopyTarget.BuilderImpl> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copyFromBuilder(crossRegionCopyTargets);
        }

        @Override
        public final Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copy(crossRegionCopyTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(CrossRegionCopyTarget ... crossRegionCopyTargets) {
            this.crossRegionCopyTargets(Arrays.asList(crossRegionCopyTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder> ... crossRegionCopyTargets) {
            this.crossRegionCopyTargets(Stream.of(crossRegionCopyTargets).map(c -> (CrossRegionCopyTarget)((CrossRegionCopyTarget.Builder)CrossRegionCopyTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getExtendDeletion() {
            return this.extendDeletion;
        }

        public final void setExtendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
        }

        @Override
        public final Builder extendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
            return this;
        }

        public final Exclusions.Builder getExclusions() {
            return this.exclusions != null ? this.exclusions.toBuilder() : null;
        }

        public final void setExclusions(Exclusions.BuilderImpl exclusions) {
            this.exclusions = exclusions != null ? exclusions.build() : null;
        }

        @Override
        public final Builder exclusions(Exclusions exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public PolicyDetails build() {
            return new PolicyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyDetails> {
        public Builder policyType(String var1);

        public Builder policyType(PolicyTypeValues var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceTypeValues> var1);

        public Builder resourceTypes(ResourceTypeValues ... var1);

        public Builder resourceLocationsWithStrings(Collection<String> var1);

        public Builder resourceLocationsWithStrings(String ... var1);

        public Builder resourceLocations(Collection<ResourceLocationValues> var1);

        public Builder resourceLocations(ResourceLocationValues ... var1);

        public Builder targetTags(Collection<Tag> var1);

        public Builder targetTags(Tag ... var1);

        public Builder targetTags(Consumer<Tag.Builder> ... var1);

        public Builder schedules(Collection<Schedule> var1);

        public Builder schedules(Schedule ... var1);

        public Builder schedules(Consumer<Schedule.Builder> ... var1);

        public Builder parameters(Parameters var1);

        default public Builder parameters(Consumer<Parameters.Builder> parameters) {
            return this.parameters((Parameters)((Parameters.Builder)Parameters.builder().applyMutation(parameters)).build());
        }

        public Builder eventSource(EventSource var1);

        default public Builder eventSource(Consumer<EventSource.Builder> eventSource) {
            return this.eventSource((EventSource)((EventSource.Builder)EventSource.builder().applyMutation(eventSource)).build());
        }

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder policyLanguage(String var1);

        public Builder policyLanguage(PolicyLanguageValues var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceTypeValues var1);

        public Builder createInterval(Integer var1);

        public Builder retainInterval(Integer var1);

        public Builder copyTags(Boolean var1);

        public Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> var1);

        public Builder crossRegionCopyTargets(CrossRegionCopyTarget ... var1);

        public Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder> ... var1);

        public Builder extendDeletion(Boolean var1);

        public Builder exclusions(Exclusions var1);

        default public Builder exclusions(Consumer<Exclusions.Builder> exclusions) {
            return this.exclusions((Exclusions)((Exclusions.Builder)Exclusions.builder().applyMutation(exclusions)).build());
        }
    }
}

