/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.ExcludeTagsListCopier;
import software.amazon.awssdk.services.dlm.model.ExcludeVolumeTypesListCopier;
import software.amazon.awssdk.services.dlm.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Exclusions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Exclusions> {
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeBootVolumes").getter(Exclusions.getter(Exclusions::excludeBootVolumes)).setter(Exclusions.setter(Builder::excludeBootVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolumes").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_VOLUME_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeVolumeTypes").getter(Exclusions.getter(Exclusions::excludeVolumeTypes)).setter(Exclusions.setter(Builder::excludeVolumeTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeVolumeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> EXCLUDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeTags").getter(Exclusions.getter(Exclusions::excludeTags)).setter(Exclusions.setter(Builder::excludeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDE_BOOT_VOLUMES_FIELD, EXCLUDE_VOLUME_TYPES_FIELD, EXCLUDE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Exclusions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean excludeBootVolumes;
    private final List<String> excludeVolumeTypes;
    private final List<Tag> excludeTags;

    private Exclusions(BuilderImpl builder) {
        this.excludeBootVolumes = builder.excludeBootVolumes;
        this.excludeVolumeTypes = builder.excludeVolumeTypes;
        this.excludeTags = builder.excludeTags;
    }

    public final Boolean excludeBootVolumes() {
        return this.excludeBootVolumes;
    }

    public final boolean hasExcludeVolumeTypes() {
        return this.excludeVolumeTypes != null && !(this.excludeVolumeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludeVolumeTypes() {
        return this.excludeVolumeTypes;
    }

    public final boolean hasExcludeTags() {
        return this.excludeTags != null && !(this.excludeTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> excludeTags() {
        return this.excludeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeBootVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeVolumeTypes() ? this.excludeVolumeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeTags() ? this.excludeTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Exclusions)) {
            return false;
        }
        Exclusions other = (Exclusions)obj;
        return Objects.equals(this.excludeBootVolumes(), other.excludeBootVolumes()) && this.hasExcludeVolumeTypes() == other.hasExcludeVolumeTypes() && Objects.equals(this.excludeVolumeTypes(), other.excludeVolumeTypes()) && this.hasExcludeTags() == other.hasExcludeTags() && Objects.equals(this.excludeTags(), other.excludeTags());
    }

    public final String toString() {
        return ToString.builder((String)"Exclusions").add("ExcludeBootVolumes", (Object)this.excludeBootVolumes()).add("ExcludeVolumeTypes", this.hasExcludeVolumeTypes() ? this.excludeVolumeTypes() : null).add("ExcludeTags", this.hasExcludeTags() ? this.excludeTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcludeBootVolumes": {
                return Optional.ofNullable(clazz.cast(this.excludeBootVolumes()));
            }
            case "ExcludeVolumeTypes": {
                return Optional.ofNullable(clazz.cast(this.excludeVolumeTypes()));
            }
            case "ExcludeTags": {
                return Optional.ofNullable(clazz.cast(this.excludeTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExcludeBootVolumes", EXCLUDE_BOOT_VOLUMES_FIELD);
        map.put("ExcludeVolumeTypes", EXCLUDE_VOLUME_TYPES_FIELD);
        map.put("ExcludeTags", EXCLUDE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Exclusions, T> g) {
        return obj -> g.apply((Exclusions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean excludeBootVolumes;
        private List<String> excludeVolumeTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> excludeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Exclusions model) {
            this.excludeBootVolumes(model.excludeBootVolumes);
            this.excludeVolumeTypes(model.excludeVolumeTypes);
            this.excludeTags(model.excludeTags);
        }

        public final Boolean getExcludeBootVolumes() {
            return this.excludeBootVolumes;
        }

        public final void setExcludeBootVolumes(Boolean excludeBootVolumes) {
            this.excludeBootVolumes = excludeBootVolumes;
        }

        @Override
        public final Builder excludeBootVolumes(Boolean excludeBootVolumes) {
            this.excludeBootVolumes = excludeBootVolumes;
            return this;
        }

        public final Collection<String> getExcludeVolumeTypes() {
            if (this.excludeVolumeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeVolumeTypes;
        }

        public final void setExcludeVolumeTypes(Collection<String> excludeVolumeTypes) {
            this.excludeVolumeTypes = ExcludeVolumeTypesListCopier.copy(excludeVolumeTypes);
        }

        @Override
        public final Builder excludeVolumeTypes(Collection<String> excludeVolumeTypes) {
            this.excludeVolumeTypes = ExcludeVolumeTypesListCopier.copy(excludeVolumeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeVolumeTypes(String ... excludeVolumeTypes) {
            this.excludeVolumeTypes(Arrays.asList(excludeVolumeTypes));
            return this;
        }

        public final List<Tag.Builder> getExcludeTags() {
            List<Tag.Builder> result = ExcludeTagsListCopier.copyToBuilder(this.excludeTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeTags(Collection<Tag.BuilderImpl> excludeTags) {
            this.excludeTags = ExcludeTagsListCopier.copyFromBuilder(excludeTags);
        }

        @Override
        public final Builder excludeTags(Collection<Tag> excludeTags) {
            this.excludeTags = ExcludeTagsListCopier.copy(excludeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeTags(Tag ... excludeTags) {
            this.excludeTags(Arrays.asList(excludeTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeTags(Consumer<Tag.Builder> ... excludeTags) {
            this.excludeTags(Stream.of(excludeTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Exclusions build() {
            return new Exclusions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Exclusions> {
        public Builder excludeBootVolumes(Boolean var1);

        public Builder excludeVolumeTypes(Collection<String> var1);

        public Builder excludeVolumeTypes(String ... var1);

        public Builder excludeTags(Collection<Tag> var1);

        public Builder excludeTags(Tag ... var1);

        public Builder excludeTags(Consumer<Tag.Builder> ... var1);
    }
}

