/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DirectoryUnavailableReason {
    INVALID_DIRECTORY_STATE("INVALID_DIRECTORY_STATE"),
    DIRECTORY_TIMEOUT("DIRECTORY_TIMEOUT"),
    DIRECTORY_RESOURCES_EXCEEDED("DIRECTORY_RESOURCES_EXCEEDED"),
    NO_DISK_SPACE("NO_DISK_SPACE"),
    TRUST_AUTH_FAILURE("TRUST_AUTH_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DirectoryUnavailableReason> VALUE_MAP;
    private final String value;

    private DirectoryUnavailableReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectoryUnavailableReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectoryUnavailableReason> knownValues() {
        EnumSet<DirectoryUnavailableReason> knownValues = EnumSet.allOf(DirectoryUnavailableReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DirectoryUnavailableReason.class, DirectoryUnavailableReason::toString);
    }
}

