/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.DirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.directory.internal.DirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AdAssessmentLimitExceededException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.CreateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadyInRegionException;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryInDesiredStateException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.IncompatibleSettingsException;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidClientAuthStatusException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsRequest;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsResponse;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegionLimitExceededException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UnsupportedSettingsException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupResponse;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.directory.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeClientAuthenticationSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeHybridAdUpdateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeUpdateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListAdAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateDirectorySetupRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.waiters.DirectoryWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDirectoryClient
implements DirectoryClient {
    private static final Logger log = Logger.loggerFor(DefaultDirectoryClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectoryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Directory_Service#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptSharedDirectoryResponse acceptSharedDirectory(AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) throws InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadySharedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptSharedDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptSharedDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, acceptSharedDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptSharedDirectory");
            AcceptSharedDirectoryResponse acceptSharedDirectoryResponse = (AcceptSharedDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptSharedDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptSharedDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptSharedDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$acceptSharedDirectory$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddIpRoutesResponse addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) throws EntityDoesNotExistException, EntityAlreadyExistsException, InvalidParameterException, DirectoryUnavailableException, IpRouteLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddIpRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, addIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddIpRoutes");
            AddIpRoutesResponse addIpRoutesResponse = (AddIpRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddIpRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addIpRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addIpRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$addIpRoutes$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddRegionResponse addRegion(AddRegionRequest addRegionRequest) throws DirectoryUnavailableException, InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadyInRegionException, UnsupportedOperationException, DirectoryDoesNotExistException, RegionLimitExceededException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddRegionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, addRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddRegion");
            AddRegionResponse addRegionResponse = (AddRegionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addRegionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addRegionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$addRegion$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws EntityDoesNotExistException, InvalidParameterException, TagLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            AddTagsToResourceResponse addTagsToResourceResponse = (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$addTagsToResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelSchemaExtensionResponse cancelSchemaExtension(CancelSchemaExtensionRequest cancelSchemaExtensionRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSchemaExtensionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelSchemaExtensionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, cancelSchemaExtensionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSchemaExtension");
            CancelSchemaExtensionResponse cancelSchemaExtensionResponse = (CancelSchemaExtensionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSchemaExtension").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelSchemaExtensionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelSchemaExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelSchemaExtensionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$cancelSchemaExtension$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectDirectoryResponse connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)connectDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, connectDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectDirectory");
            ConnectDirectoryResponse connectDirectoryResponse = (ConnectDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)connectDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConnectDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return connectDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$connectDirectory$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            CreateAliasResponse createAliasResponse = (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createAlias$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComputerResponse createComputer(CreateComputerRequest createComputerRequest) throws AuthenticationFailedException, DirectoryUnavailableException, EntityAlreadyExistsException, EntityDoesNotExistException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComputerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createComputerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createComputerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComputer");
            CreateComputerResponse createComputerResponse = (CreateComputerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComputer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createComputerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateComputerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createComputerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createComputer$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConditionalForwarderResponse createConditionalForwarder(CreateConditionalForwarderRequest createConditionalForwarderRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConditionalForwarderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConditionalForwarderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConditionalForwarder");
            CreateConditionalForwarderResponse createConditionalForwarderResponse = (CreateConditionalForwarderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConditionalForwarder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConditionalForwarderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConditionalForwarderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createConditionalForwarder$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectoryResponse createDirectory(CreateDirectoryRequest createDirectoryRequest) throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectory");
            CreateDirectoryResponse createDirectoryResponse = (CreateDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createDirectory$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHybridAdResponse createHybridAD(CreateHybridAdRequest createHybridAdRequest) throws ClientException, ServiceException, InvalidParameterException, UnsupportedOperationException, DirectoryLimitExceededException, AdAssessmentLimitExceededException, EntityDoesNotExistException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHybridAdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHybridAdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createHybridAdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHybridAD");
            CreateHybridAdResponse createHybridAdResponse = (CreateHybridAdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHybridAD").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHybridAdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHybridAdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHybridAdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createHybridAD$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLogSubscriptionResponse createLogSubscription(CreateLogSubscriptionRequest createLogSubscriptionRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, UnsupportedOperationException, InsufficientPermissionsException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLogSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createLogSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogSubscription");
            CreateLogSubscriptionResponse createLogSubscriptionResponse = (CreateLogSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLogSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLogSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createLogSubscription$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMicrosoftAdResponse createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMicrosoftAdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMicrosoftAdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createMicrosoftAdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMicrosoftAD");
            CreateMicrosoftAdResponse createMicrosoftAdResponse = (CreateMicrosoftAdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMicrosoftAD").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMicrosoftAdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMicrosoftAdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMicrosoftAdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createMicrosoftAD$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws EntityDoesNotExistException, InvalidParameterException, SnapshotLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createSnapshot$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrustResponse createTrust(CreateTrustRequest createTrustRequest) throws EntityAlreadyExistsException, EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrustResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, createTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrust");
            CreateTrustResponse createTrustResponse = (CreateTrustResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrust").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTrustRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrustResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$createTrust$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAdAssessmentResponse deleteADAssessment(DeleteAdAssessmentRequest deleteAdAssessmentRequest) throws ClientException, ServiceException, InvalidParameterException, UnsupportedOperationException, EntityDoesNotExistException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdAssessmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteAdAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteADAssessment");
            DeleteAdAssessmentResponse deleteAdAssessmentResponse = (DeleteAdAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteADAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAdAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAdAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAdAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteADAssessment$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConditionalForwarderResponse deleteConditionalForwarder(DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) throws EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConditionalForwarderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConditionalForwarderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConditionalForwarder");
            DeleteConditionalForwarderResponse deleteConditionalForwarderResponse = (DeleteConditionalForwarderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConditionalForwarder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConditionalForwarderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConditionalForwarderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteConditionalForwarder$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectoryResponse deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectory");
            DeleteDirectoryResponse deleteDirectoryResponse = (DeleteDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteDirectory$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLogSubscriptionResponse deleteLogSubscription(DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) throws EntityDoesNotExistException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLogSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteLogSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogSubscription");
            DeleteLogSubscriptionResponse deleteLogSubscriptionResponse = (DeleteLogSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLogSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLogSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteLogSubscription$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteSnapshot$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrustResponse deleteTrust(DeleteTrustRequest deleteTrustRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrustResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deleteTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrust");
            DeleteTrustResponse deleteTrustResponse = (DeleteTrustResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrust").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTrustRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrustResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deleteTrust$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterCertificateResponse deregisterCertificate(DeregisterCertificateRequest deregisterCertificateRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, CertificateDoesNotExistException, CertificateInUseException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deregisterCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterCertificate");
            DeregisterCertificateResponse deregisterCertificateResponse = (DeregisterCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deregisterCertificate$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterEventTopicResponse deregisterEventTopic(DeregisterEventTopicRequest deregisterEventTopicRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterEventTopicResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterEventTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, deregisterEventTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterEventTopic");
            DeregisterEventTopicResponse deregisterEventTopicResponse = (DeregisterEventTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterEventTopic").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterEventTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterEventTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$deregisterEventTopic$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAdAssessmentResponse describeADAssessment(DescribeAdAssessmentRequest describeAdAssessmentRequest) throws ClientException, ServiceException, InvalidParameterException, UnsupportedOperationException, EntityDoesNotExistException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAdAssessmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAdAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeAdAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeADAssessment");
            DescribeAdAssessmentResponse describeAdAssessmentResponse = (DescribeAdAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeADAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAdAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAdAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAdAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeADAssessment$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCaEnrollmentPolicyResponse describeCAEnrollmentPolicy(DescribeCaEnrollmentPolicyRequest describeCaEnrollmentPolicyRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCaEnrollmentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCaEnrollmentPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeCaEnrollmentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCAEnrollmentPolicy");
            DescribeCaEnrollmentPolicyResponse describeCaEnrollmentPolicyResponse = (DescribeCaEnrollmentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCAEnrollmentPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCaEnrollmentPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCaEnrollmentPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCaEnrollmentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeCAEnrollmentPolicy$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, CertificateDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificate");
            DescribeCertificateResponse describeCertificateResponse = (DescribeCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeCertificate$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClientAuthenticationSettingsResponse describeClientAuthenticationSettings(DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, AccessDeniedException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientAuthenticationSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClientAuthenticationSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeClientAuthenticationSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClientAuthenticationSettings");
            DescribeClientAuthenticationSettingsResponse describeClientAuthenticationSettingsResponse = (DescribeClientAuthenticationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClientAuthenticationSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClientAuthenticationSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClientAuthenticationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClientAuthenticationSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeClientAuthenticationSettings$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConditionalForwardersResponse describeConditionalForwarders(DescribeConditionalForwardersRequest describeConditionalForwardersRequest) throws EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConditionalForwardersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConditionalForwardersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConditionalForwarders");
            DescribeConditionalForwardersResponse describeConditionalForwardersResponse = (DescribeConditionalForwardersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConditionalForwarders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConditionalForwardersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConditionalForwardersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConditionalForwardersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeConditionalForwarders$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectoriesResponse describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest) throws EntityDoesNotExistException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectories");
            DescribeDirectoriesResponse describeDirectoriesResponse = (DescribeDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDirectoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeDirectories$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectoryDataAccessResponse describeDirectoryDataAccess(DescribeDirectoryDataAccessRequest describeDirectoryDataAccessRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectoryDataAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectoryDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeDirectoryDataAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectoryDataAccess");
            DescribeDirectoryDataAccessResponse describeDirectoryDataAccessResponse = (DescribeDirectoryDataAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectoryDataAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDirectoryDataAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectoryDataAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectoryDataAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeDirectoryDataAccess$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainControllersResponse describeDomainControllers(DescribeDomainControllersRequest describeDomainControllersRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainControllersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainControllersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeDomainControllersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainControllers");
            DescribeDomainControllersResponse describeDomainControllersResponse = (DescribeDomainControllersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainControllers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainControllersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainControllersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainControllersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeDomainControllers$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventTopicsResponse describeEventTopics(DescribeEventTopicsRequest describeEventTopicsRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTopicsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventTopicsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeEventTopicsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventTopics");
            DescribeEventTopicsResponse describeEventTopicsResponse = (DescribeEventTopicsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTopics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventTopicsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventTopicsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventTopicsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeEventTopics$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHybridAdUpdateResponse describeHybridADUpdate(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest) throws ClientException, ServiceException, UnsupportedOperationException, DirectoryDoesNotExistException, InvalidParameterException, InvalidNextTokenException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHybridAdUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeHybridAdUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeHybridAdUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHybridADUpdate");
            DescribeHybridAdUpdateResponse describeHybridAdUpdateResponse = (DescribeHybridAdUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHybridADUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeHybridAdUpdateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeHybridAdUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeHybridAdUpdateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeHybridADUpdate$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLdapsSettingsResponse describeLDAPSSettings(DescribeLdapsSettingsRequest describeLdapsSettingsRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLdapsSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLdapsSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeLdapsSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLDAPSSettings");
            DescribeLdapsSettingsResponse describeLdapsSettingsResponse = (DescribeLdapsSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLDAPSSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLdapsSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLdapsSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLdapsSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeLDAPSSettings$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRegionsResponse describeRegions(DescribeRegionsRequest describeRegionsRequest) throws InvalidParameterException, DirectoryDoesNotExistException, UnsupportedOperationException, InvalidNextTokenException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRegionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeRegionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegions");
            DescribeRegionsResponse describeRegionsResponse = (DescribeRegionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRegionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRegionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRegionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeRegions$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSettingsResponse describeSettings(DescribeSettingsRequest describeSettingsRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSettings");
            DescribeSettingsResponse describeSettingsResponse = (DescribeSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeSettings$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSharedDirectoriesResponse describeSharedDirectories(DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSharedDirectoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSharedDirectoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeSharedDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSharedDirectories");
            DescribeSharedDirectoriesResponse describeSharedDirectoriesResponse = (DescribeSharedDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSharedDirectories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSharedDirectoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSharedDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSharedDirectoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeSharedDirectories$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws EntityDoesNotExistException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            DescribeSnapshotsResponse describeSnapshotsResponse = (DescribeSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeSnapshots$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustsResponse describeTrusts(DescribeTrustsRequest describeTrustsRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeTrustsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrusts");
            DescribeTrustsResponse describeTrustsResponse = (DescribeTrustsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrusts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrustsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrustsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrustsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeTrusts$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUpdateDirectoryResponse describeUpdateDirectory(DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest) throws DirectoryDoesNotExistException, InvalidParameterException, AccessDeniedException, ClientException, ServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUpdateDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUpdateDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, describeUpdateDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUpdateDirectory");
            DescribeUpdateDirectoryResponse describeUpdateDirectoryResponse = (DescribeUpdateDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUpdateDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeUpdateDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUpdateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUpdateDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$describeUpdateDirectory$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableCaEnrollmentPolicyResponse disableCAEnrollmentPolicy(DisableCaEnrollmentPolicyRequest disableCaEnrollmentPolicyRequest) throws DirectoryDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, DisableAlreadyInProgressException, EntityDoesNotExistException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableCaEnrollmentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableCaEnrollmentPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, disableCaEnrollmentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableCAEnrollmentPolicy");
            DisableCaEnrollmentPolicyResponse disableCaEnrollmentPolicyResponse = (DisableCaEnrollmentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableCAEnrollmentPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableCaEnrollmentPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableCaEnrollmentPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableCaEnrollmentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableCAEnrollmentPolicy$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableClientAuthenticationResponse disableClientAuthentication(DisableClientAuthenticationRequest disableClientAuthenticationRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidClientAuthStatusException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableClientAuthenticationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableClientAuthenticationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, disableClientAuthenticationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableClientAuthentication");
            DisableClientAuthenticationResponse disableClientAuthenticationResponse = (DisableClientAuthenticationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableClientAuthentication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableClientAuthenticationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableClientAuthenticationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableClientAuthenticationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableClientAuthentication$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDirectoryDataAccessResponse disableDirectoryDataAccess(DisableDirectoryDataAccessRequest disableDirectoryDataAccessRequest) throws DirectoryDoesNotExistException, DirectoryUnavailableException, UnsupportedOperationException, DirectoryInDesiredStateException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDirectoryDataAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableDirectoryDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, disableDirectoryDataAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDirectoryDataAccess");
            DisableDirectoryDataAccessResponse disableDirectoryDataAccessResponse = (DisableDirectoryDataAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDirectoryDataAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableDirectoryDataAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableDirectoryDataAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableDirectoryDataAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableDirectoryDataAccess$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableLdapsResponse disableLDAPS(DisableLdapsRequest disableLdapsRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, InvalidLdapsStatusException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableLdapsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, disableLdapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableLDAPS");
            DisableLdapsResponse disableLdapsResponse = (DisableLdapsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLDAPS").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableLdapsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableLdapsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableLDAPS$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableRadiusResponse disableRadius(DisableRadiusRequest disableRadiusRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRadiusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, disableRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableRadius");
            DisableRadiusResponse disableRadiusResponse = (DisableRadiusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRadius").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableRadiusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableRadiusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableRadius$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableSsoResponse disableSso(DisableSsoRequest disableSsoRequest) throws EntityDoesNotExistException, InsufficientPermissionsException, AuthenticationFailedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableSsoResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, disableSsoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableSso");
            DisableSsoResponse disableSsoResponse = (DisableSsoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSso").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableSsoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableSsoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$disableSso$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableCaEnrollmentPolicyResponse enableCAEnrollmentPolicy(EnableCaEnrollmentPolicyRequest enableCaEnrollmentPolicyRequest) throws DirectoryDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, EntityAlreadyExistsException, EntityDoesNotExistException, EnableAlreadyInProgressException, ClientException, ServiceException, AccessDeniedException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableCaEnrollmentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableCaEnrollmentPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, enableCaEnrollmentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableCAEnrollmentPolicy");
            EnableCaEnrollmentPolicyResponse enableCaEnrollmentPolicyResponse = (EnableCaEnrollmentPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableCAEnrollmentPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableCaEnrollmentPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableCaEnrollmentPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableCaEnrollmentPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableCAEnrollmentPolicy$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableClientAuthenticationResponse enableClientAuthentication(EnableClientAuthenticationRequest enableClientAuthenticationRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidClientAuthStatusException, AccessDeniedException, NoAvailableCertificateException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableClientAuthenticationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableClientAuthenticationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, enableClientAuthenticationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableClientAuthentication");
            EnableClientAuthenticationResponse enableClientAuthenticationResponse = (EnableClientAuthenticationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableClientAuthentication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableClientAuthenticationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableClientAuthenticationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableClientAuthenticationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableClientAuthentication$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDirectoryDataAccessResponse enableDirectoryDataAccess(EnableDirectoryDataAccessRequest enableDirectoryDataAccessRequest) throws DirectoryDoesNotExistException, DirectoryUnavailableException, UnsupportedOperationException, DirectoryInDesiredStateException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDirectoryDataAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableDirectoryDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, enableDirectoryDataAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDirectoryDataAccess");
            EnableDirectoryDataAccessResponse enableDirectoryDataAccessResponse = (EnableDirectoryDataAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDirectoryDataAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableDirectoryDataAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableDirectoryDataAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableDirectoryDataAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableDirectoryDataAccess$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableLdapsResponse enableLDAPS(EnableLdapsRequest enableLdapsRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, NoAvailableCertificateException, InvalidLdapsStatusException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableLdapsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, enableLdapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableLDAPS");
            EnableLdapsResponse enableLdapsResponse = (EnableLdapsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLDAPS").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableLdapsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableLdapsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableLDAPS$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableRadiusResponse enableRadius(EnableRadiusRequest enableRadiusRequest) throws InvalidParameterException, EntityAlreadyExistsException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRadiusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, enableRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableRadius");
            EnableRadiusResponse enableRadiusResponse = (EnableRadiusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRadius").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableRadiusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableRadiusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableRadius$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableSsoResponse enableSso(EnableSsoRequest enableSsoRequest) throws EntityDoesNotExistException, InsufficientPermissionsException, AuthenticationFailedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSsoResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, enableSsoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSso");
            EnableSsoResponse enableSsoResponse = (EnableSsoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSso").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableSsoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableSsoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$enableSso$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDirectoryLimitsResponse getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDirectoryLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, getDirectoryLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectoryLimits");
            GetDirectoryLimitsResponse getDirectoryLimitsResponse = (GetDirectoryLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectoryLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDirectoryLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDirectoryLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDirectoryLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$getDirectoryLimits$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotLimitsResponse getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSnapshotLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, getSnapshotLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshotLimits");
            GetSnapshotLimitsResponse getSnapshotLimitsResponse = (GetSnapshotLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshotLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSnapshotLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSnapshotLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSnapshotLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$getSnapshotLimits$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAdAssessmentsResponse listADAssessments(ListAdAssessmentsRequest listAdAssessmentsRequest) throws ClientException, ServiceException, InvalidParameterException, UnsupportedOperationException, DirectoryDoesNotExistException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAdAssessmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAdAssessmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, listAdAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListADAssessments");
            ListAdAssessmentsResponse listAdAssessmentsResponse = (ListAdAssessmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListADAssessments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAdAssessmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAdAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAdAssessmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listADAssessments$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest) throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidParameterException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, listCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificates");
            ListCertificatesResponse listCertificatesResponse = (ListCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listCertificates$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIpRoutesResponse listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIpRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, listIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIpRoutes");
            ListIpRoutesResponse listIpRoutesResponse = (ListIpRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIpRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIpRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIpRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listIpRoutes$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLogSubscriptionsResponse listLogSubscriptions(ListLogSubscriptionsRequest listLogSubscriptionsRequest) throws EntityDoesNotExistException, InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogSubscriptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLogSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, listLogSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogSubscriptions");
            ListLogSubscriptionsResponse listLogSubscriptionsResponse = (ListLogSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listLogSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLogSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLogSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listLogSubscriptions$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSchemaExtensionsResponse listSchemaExtensions(ListSchemaExtensionsRequest listSchemaExtensionsRequest) throws InvalidNextTokenException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemaExtensionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSchemaExtensionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, listSchemaExtensionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemaExtensions");
            ListSchemaExtensionsResponse listSchemaExtensionsResponse = (ListSchemaExtensionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemaExtensions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSchemaExtensionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSchemaExtensionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSchemaExtensionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listSchemaExtensions$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$listTagsForResource$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterCertificateResponse registerCertificate(RegisterCertificateRequest registerCertificateRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, InvalidCertificateException, CertificateLimitExceededException, CertificateAlreadyExistsException, UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, registerCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterCertificate");
            RegisterCertificateResponse registerCertificateResponse = (RegisterCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$registerCertificate$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterEventTopicResponse registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterEventTopicResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerEventTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, registerEventTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterEventTopic");
            RegisterEventTopicResponse registerEventTopicResponse = (RegisterEventTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterEventTopic").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerEventTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerEventTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$registerEventTopic$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectSharedDirectoryResponse rejectSharedDirectory(RejectSharedDirectoryRequest rejectSharedDirectoryRequest) throws InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadySharedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectSharedDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectSharedDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, rejectSharedDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectSharedDirectory");
            RejectSharedDirectoryResponse rejectSharedDirectoryResponse = (RejectSharedDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectSharedDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectSharedDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectSharedDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$rejectSharedDirectory$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveIpRoutesResponse removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) throws EntityDoesNotExistException, InvalidParameterException, DirectoryUnavailableException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveIpRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, removeIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveIpRoutes");
            RemoveIpRoutesResponse removeIpRoutesResponse = (RemoveIpRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveIpRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeIpRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeIpRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$removeIpRoutes$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveRegionResponse removeRegion(RemoveRegionRequest removeRegionRequest) throws DirectoryUnavailableException, DirectoryDoesNotExistException, UnsupportedOperationException, AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveRegionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, removeRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveRegion");
            RemoveRegionResponse removeRegionResponse = (RemoveRegionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeRegionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeRegionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$removeRegion$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsFromResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            RemoveTagsFromResourceResponse removeTagsFromResourceResponse = (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$removeTagsFromResource$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetUserPasswordResponse resetUserPassword(ResetUserPasswordRequest resetUserPasswordRequest) throws DirectoryUnavailableException, UserDoesNotExistException, InvalidPasswordException, UnsupportedOperationException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetUserPasswordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DirectoryAlreadySharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                }
                case "EnableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                }
                case "DirectoryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                }
                case "InvalidCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "DirectoryNotSharedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                }
                case "RegionLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                }
                case "DisableAlreadyInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                }
                case "EntityDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                }
                case "DirectoryLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                }
                case "DirectoryDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "CertificateAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                }
                case "DirectoryAlreadyInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                }
                case "DomainControllerLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                }
                case "UserDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "IncompatibleSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                }
                case "AuthenticationFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                }
                case "DirectoryInDesiredStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "CertificateLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                }
                case "OrganizationsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                }
                case "InvalidLDAPSStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "CertificateDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "SnapshotLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "ADAssessmentLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                }
                case "InvalidClientAuthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                }
                case "UnsupportedSettingsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "NoAvailableCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                }
                case "InvalidTargetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                }
                case "IpRouteLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                }
                case "TagLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                }
                case "ShareLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                }
                case "CertificateInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetUserPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryClient.resolveMetricPublishers(clientConfiguration, resetUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetUserPassword");
            ResetUserPasswordResponse resetUserPasswordResponse = (ResetUserPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetUserPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetUserPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetUserPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryClient.lambda$resetUserPassword$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreFromSnapshotResponse restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest) throws EntityDoesNotExistException, InvalidP