/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.DirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.directory.internal.DirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AdAssessmentLimitExceededException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.CreateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadyInRegionException;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryInDesiredStateException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.IncompatibleSettingsException;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidClientAuthStatusException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsRequest;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsResponse;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegionLimitExceededException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UnsupportedSettingsException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupResponse;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.directory.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeClientAuthenticationSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeHybridAdUpdateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeUpdateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListAdAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateDirectorySetupRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.waiters.DirectoryAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDirectoryAsyncClient
implements DirectoryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectoryAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultDirectoryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Directory_Service#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AcceptSharedDirectoryResponse> acceptSharedDirectory(AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptSharedDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, acceptSharedDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptSharedDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptSharedDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AcceptSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)acceptSharedDirectoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$acceptSharedDirectory$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$acceptSharedDirectory$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddIpRoutesResponse> addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, addIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddIpRoutesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddIpRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addIpRoutesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$addIpRoutes$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$addIpRoutes$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddRegionResponse> addRegion(AddRegionRequest addRegionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, addRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddRegionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addRegionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$addRegion$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$addRegion$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addTagsToResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$addTagsToResource$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$addTagsToResource$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelSchemaExtensionResponse> cancelSchemaExtension(CancelSchemaExtensionRequest cancelSchemaExtensionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelSchemaExtensionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, cancelSchemaExtensionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSchemaExtension");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSchemaExtensionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSchemaExtension").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelSchemaExtensionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelSchemaExtensionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$cancelSchemaExtension$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$cancelSchemaExtension$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConnectDirectoryResponse> connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)connectDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, connectDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ConnectDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)connectDirectoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$connectDirectory$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$connectDirectory$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createAlias$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createAlias$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateComputerResponse> createComputer(CreateComputerRequest createComputerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createComputerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createComputerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComputer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComputerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComputer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateComputerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createComputerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createComputer$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createComputer$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateConditionalForwarderResponse> createConditionalForwarder(CreateConditionalForwarderRequest createConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConditionalForwarderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConditionalForwarderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConditionalForwarder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createConditionalForwarderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createConditionalForwarder$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createConditionalForwarder$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDirectoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createDirectory$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createDirectory$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHybridAdResponse> createHybridAD(CreateHybridAdRequest createHybridAdRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHybridAdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createHybridAdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHybridAD");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHybridAdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHybridAD").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateHybridAdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createHybridAdRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createHybridAD$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createHybridAD$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLogSubscriptionResponse> createLogSubscription(CreateLogSubscriptionRequest createLogSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLogSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createLogSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLogSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLogSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLogSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createLogSubscription$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createLogSubscription$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMicrosoftAdResponse> createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMicrosoftAdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createMicrosoftAdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMicrosoftAD");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMicrosoftAdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMicrosoftAD").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateMicrosoftAdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMicrosoftAdRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createMicrosoftAD$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createMicrosoftAD$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createSnapshot$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createSnapshot$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrustResponse> createTrust(CreateTrustRequest createTrustRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, createTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrustResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrust").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTrustRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$createTrust$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$createTrust$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAdAssessmentResponse> deleteADAssessment(DeleteAdAssessmentRequest deleteAdAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAdAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteADAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdAssessmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteADAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAdAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAdAssessmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deleteADAssessment$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deleteADAssessment$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConditionalForwarderResponse> deleteConditionalForwarder(DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConditionalForwarderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConditionalForwarderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConditionalForwarderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConditionalForwarder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConditionalForwarderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConditionalForwarderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deleteConditionalForwarder$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deleteConditionalForwarder$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDirectoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deleteDirectory$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deleteDirectory$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLogSubscriptionResponse> deleteLogSubscription(DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLogSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLogSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLogSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLogSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLogSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLogSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deleteLogSubscription$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deleteLogSubscription$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deleteSnapshot$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deleteSnapshot$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTrustResponse> deleteTrust(DeleteTrustRequest deleteTrustRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTrustRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrustResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrust").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTrustRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTrustRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deleteTrust$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deleteTrust$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterCertificateResponse> deregisterCertificate(DeregisterCertificateRequest deregisterCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deregisterCertificate$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deregisterCertificate$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterEventTopicResponse> deregisterEventTopic(DeregisterEventTopicRequest deregisterEventTopicRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterEventTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterEventTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterEventTopicResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterEventTopic").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterEventTopicRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$deregisterEventTopic$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$deregisterEventTopic$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAdAssessmentResponse> describeADAssessment(DescribeAdAssessmentRequest describeAdAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAdAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeAdAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeADAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAdAssessmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeADAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAdAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAdAssessmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeADAssessment$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeADAssessment$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCaEnrollmentPolicyResponse> describeCAEnrollmentPolicy(DescribeCaEnrollmentPolicyRequest describeCaEnrollmentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCaEnrollmentPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeCaEnrollmentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCAEnrollmentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCaEnrollmentPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCAEnrollmentPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCaEnrollmentPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCaEnrollmentPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeCAEnrollmentPolicy$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeCAEnrollmentPolicy$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(DescribeCertificateRequest describeCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeCertificate$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeCertificate$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClientAuthenticationSettingsResponse> describeClientAuthenticationSettings(DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClientAuthenticationSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeClientAuthenticationSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClientAuthenticationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientAuthenticationSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClientAuthenticationSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClientAuthenticationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClientAuthenticationSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeClientAuthenticationSettings$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeClientAuthenticationSettings$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConditionalForwardersResponse> describeConditionalForwarders(DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConditionalForwardersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConditionalForwarders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConditionalForwardersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConditionalForwarders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConditionalForwardersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConditionalForwardersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeConditionalForwarders$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeConditionalForwarders$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDirectoriesResponse> describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDirectoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeDirectories$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeDirectories$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDirectoryDataAccessResponse> describeDirectoryDataAccess(DescribeDirectoryDataAccessRequest describeDirectoryDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectoryDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeDirectoryDataAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectoryDataAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectoryDataAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectoryDataAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDirectoryDataAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDirectoryDataAccessRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeDirectoryDataAccess$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeDirectoryDataAccess$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDomainControllersResponse> describeDomainControllers(DescribeDomainControllersRequest describeDomainControllersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainControllersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeDomainControllersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainControllers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainControllersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainControllers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDomainControllersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDomainControllersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeDomainControllers$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeDomainControllers$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventTopicsResponse> describeEventTopics(DescribeEventTopicsRequest describeEventTopicsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventTopicsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventTopicsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventTopics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTopicsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTopics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventTopicsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventTopicsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeEventTopics$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeEventTopics$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeHybridAdUpdateResponse> describeHybridADUpdate(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeHybridAdUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeHybridAdUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHybridADUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHybridAdUpdateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHybridADUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeHybridAdUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeHybridAdUpdateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeHybridADUpdate$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeHybridADUpdate$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLdapsSettingsResponse> describeLDAPSSettings(DescribeLdapsSettingsRequest describeLdapsSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLdapsSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeLdapsSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLDAPSSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLdapsSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLDAPSSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLdapsSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLdapsSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeLDAPSSettings$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeLDAPSSettings$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRegionsResponse> describeRegions(DescribeRegionsRequest describeRegionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRegionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeRegionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRegionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRegionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeRegions$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeRegions$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSettingsResponse> describeSettings(DescribeSettingsRequest describeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeSettings$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeSettings$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSharedDirectoriesResponse> describeSharedDirectories(DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSharedDirectoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeSharedDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSharedDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSharedDirectoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSharedDirectories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSharedDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSharedDirectoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeSharedDirectories$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeSharedDirectories$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeSnapshots$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeSnapshots$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrustsResponse> describeTrusts(DescribeTrustsRequest describeTrustsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrustsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeTrustsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrusts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrusts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTrustsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTrustsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeTrusts$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeTrusts$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUpdateDirectoryResponse> describeUpdateDirectory(DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUpdateDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, describeUpdateDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUpdateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUpdateDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUpdateDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeUpdateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeUpdateDirectoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$describeUpdateDirectory$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$describeUpdateDirectory$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableCaEnrollmentPolicyResponse> disableCAEnrollmentPolicy(DisableCaEnrollmentPolicyRequest disableCaEnrollmentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableCaEnrollmentPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, disableCaEnrollmentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableCAEnrollmentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableCaEnrollmentPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableCAEnrollmentPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableCaEnrollmentPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableCaEnrollmentPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$disableCAEnrollmentPolicy$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$disableCAEnrollmentPolicy$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableClientAuthenticationResponse> disableClientAuthentication(DisableClientAuthenticationRequest disableClientAuthenticationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableClientAuthenticationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, disableClientAuthenticationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableClientAuthentication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableClientAuthenticationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableClientAuthentication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableClientAuthenticationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableClientAuthenticationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$disableClientAuthentication$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$disableClientAuthentication$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableDirectoryDataAccessResponse> disableDirectoryDataAccess(DisableDirectoryDataAccessRequest disableDirectoryDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableDirectoryDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, disableDirectoryDataAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDirectoryDataAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDirectoryDataAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDirectoryDataAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableDirectoryDataAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableDirectoryDataAccessRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$disableDirectoryDataAccess$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$disableDirectoryDataAccess$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableLdapsResponse> disableLDAPS(DisableLdapsRequest disableLdapsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, disableLdapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableLdapsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLDAPS").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableLdapsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$disableLDAPS$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$disableLDAPS$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableRadiusResponse> disableRadius(DisableRadiusRequest disableRadiusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, disableRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRadiusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRadius").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableRadiusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$disableRadius$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$disableRadius$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableSsoResponse> disableSso(DisableSsoRequest disableSsoRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, disableSsoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableSsoResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSso").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableSsoRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$disableSso$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$disableSso$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableCaEnrollmentPolicyResponse> enableCAEnrollmentPolicy(EnableCaEnrollmentPolicyRequest enableCaEnrollmentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableCaEnrollmentPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, enableCaEnrollmentPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableCAEnrollmentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableCaEnrollmentPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableCAEnrollmentPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableCaEnrollmentPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableCaEnrollmentPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$enableCAEnrollmentPolicy$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$enableCAEnrollmentPolicy$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableClientAuthenticationResponse> enableClientAuthentication(EnableClientAuthenticationRequest enableClientAuthenticationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableClientAuthenticationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, enableClientAuthenticationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableClientAuthentication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableClientAuthenticationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableClientAuthentication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableClientAuthenticationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableClientAuthenticationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$enableClientAuthentication$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$enableClientAuthentication$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableDirectoryDataAccessResponse> enableDirectoryDataAccess(EnableDirectoryDataAccessRequest enableDirectoryDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableDirectoryDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, enableDirectoryDataAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDirectoryDataAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDirectoryDataAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDirectoryDataAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableDirectoryDataAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableDirectoryDataAccessRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$enableDirectoryDataAccess$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$enableDirectoryDataAccess$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableLdapsResponse> enableLDAPS(EnableLdapsRequest enableLdapsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, enableLdapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableLdapsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLDAPS").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableLdapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableLdapsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$enableLDAPS$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$enableLDAPS$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableRadiusResponse> enableRadius(EnableRadiusRequest enableRadiusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, enableRadiusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRadiusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRadius").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableRadiusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableRadiusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$enableRadius$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$enableRadius$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableSsoResponse> enableSso(EnableSsoRequest enableSsoRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, enableSsoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSsoResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSso").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableSsoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableSsoRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$enableSso$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$enableSso$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDirectoryLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, getDirectoryLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectoryLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectoryLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDirectoryLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDirectoryLimitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$getDirectoryLimits$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$getDirectoryLimits$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSnapshotLimitsResponse> getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSnapshotLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, getSnapshotLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshotLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshotLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSnapshotLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSnapshotLimitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$getSnapshotLimits$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$getSnapshotLimits$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAdAssessmentsResponse> listADAssessments(ListAdAssessmentsRequest listAdAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAdAssessmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, listAdAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListADAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAdAssessmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListADAssessments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAdAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAdAssessmentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$listADAssessments$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$listADAssessments$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, listCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCertificatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$listCertificates$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$listCertificates$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIpRoutesResponse> listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, listIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIpRoutesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIpRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIpRoutesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$listIpRoutes$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$listIpRoutes$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions(ListLogSubscriptionsRequest listLogSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLogSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, listLogSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogSubscriptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLogSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLogSubscriptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$listLogSubscriptions$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$listLogSubscriptions$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSchemaExtensionsResponse> listSchemaExtensions(ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSchemaExtensionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, listSchemaExtensionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemaExtensions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemaExtensionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemaExtensions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSchemaExtensionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSchemaExtensionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$listSchemaExtensions$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$listSchemaExtensions$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$listTagsForResource$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$listTagsForResource$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterCertificateResponse> registerCertificate(RegisterCertificateRequest registerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, registerCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$registerCertificate$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$registerCertificate$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterEventTopicResponse> registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerEventTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, registerEventTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterEventTopicResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterEventTopic").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterEventTopicRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerEventTopicRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$registerEventTopic$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$registerEventTopic$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RejectSharedDirectoryResponse> rejectSharedDirectory(RejectSharedDirectoryRequest rejectSharedDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectSharedDirectoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, rejectSharedDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectSharedDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectSharedDirectory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RejectSharedDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rejectSharedDirectoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$rejectSharedDirectory$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$rejectSharedDirectory$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveIpRoutesResponse> removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, removeIpRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveIpRoutesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                    }
                    case "RegionLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                    }
                    case "DisableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                    }
                    case "EntityDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                    }
                    case "DirectoryLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                    }
                    case "DirectoryDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "CertificateAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                    }
                    case "DirectoryAlreadyInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                    }
                    case "DomainControllerLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
                    }
                    case "UserDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "IncompatibleSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                    }
                    case "AuthenticationFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                    }
                    case "DirectoryInDesiredStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                    }
                    case "InsufficientPermissionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                    }
                    case "CertificateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                    }
                    case "OrganizationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsException::builder).build());
                    }
                    case "InvalidLDAPSStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "CertificateDoesNotExistException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "SnapshotLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "ADAssessmentLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                    }
                    case "InvalidClientAuthStatusException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                    }
                    case "UnsupportedSettingsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "NoAvailableCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                    }
                    case "InvalidTargetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTargetException::builder).build());
                    }
                    case "IpRouteLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "ShareLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                    }
                    case "CertificateInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveIpRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveIpRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeIpRoutesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDirectoryAsyncClient.lambda$removeIpRoutes$254(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDirectoryAsyncClient.lambda$removeIpRoutes$255((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveRegionResponse> removeRegion(RemoveRegionRequest removeRegionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectoryAsyncClient.resolveMetricPublishers(clientConfiguration, removeRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveRegionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "DirectoryAlreadySharedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                    }
                    case "EnableAlreadyInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                    }
                    case "DirectoryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                    }
                    case "InvalidCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                    }
                    case "DirectoryNotSharedExc