/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableCaEnrollmentPolicyRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, EnableCaEnrollmentPolicyRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(EnableCaEnrollmentPolicyRequest.getter(EnableCaEnrollmentPolicyRequest::directoryId)).setter(EnableCaEnrollmentPolicyRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> PCA_CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PcaConnectorArn").getter(EnableCaEnrollmentPolicyRequest.getter(EnableCaEnrollmentPolicyRequest::pcaConnectorArn)).setter(EnableCaEnrollmentPolicyRequest.setter(Builder::pcaConnectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PcaConnectorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, PCA_CONNECTOR_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableCaEnrollmentPolicyRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final String pcaConnectorArn;

    private EnableCaEnrollmentPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.pcaConnectorArn = builder.pcaConnectorArn;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String pcaConnectorArn() {
        return this.pcaConnectorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcaConnectorArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableCaEnrollmentPolicyRequest)) {
            return false;
        }
        EnableCaEnrollmentPolicyRequest other = (EnableCaEnrollmentPolicyRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.pcaConnectorArn(), other.pcaConnectorArn());
    }

    public final String toString() {
        return ToString.builder((String)"EnableCaEnrollmentPolicyRequest").add("DirectoryId", (Object)this.directoryId()).add("PcaConnectorArn", (Object)this.pcaConnectorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "PcaConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.pcaConnectorArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("PcaConnectorArn", PCA_CONNECTOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableCaEnrollmentPolicyRequest, T> g) {
        return obj -> g.apply((EnableCaEnrollmentPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String pcaConnectorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableCaEnrollmentPolicyRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.pcaConnectorArn(model.pcaConnectorArn);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getPcaConnectorArn() {
            return this.pcaConnectorArn;
        }

        public final void setPcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
        }

        @Override
        public final Builder pcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableCaEnrollmentPolicyRequest build() {
            return new EnableCaEnrollmentPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableCaEnrollmentPolicyRequest> {
        public Builder directoryId(String var1);

        public Builder pcaConnectorArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

