/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.services.directory.model.DnsIpv6AddrsCopier;
import software.amazon.awssdk.services.directory.model.ReplicationScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionalForwarder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionalForwarder> {
    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteDomainName").getter(ConditionalForwarder.getter(ConditionalForwarder::remoteDomainName)).setter(ConditionalForwarder.setter(Builder::remoteDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddrs").getter(ConditionalForwarder.getter(ConditionalForwarder::dnsIpAddrs)).setter(ConditionalForwarder.setter(Builder::dnsIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DNS_IPV6_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpv6Addrs").getter(ConditionalForwarder.getter(ConditionalForwarder::dnsIpv6Addrs)).setter(ConditionalForwarder.setter(Builder::dnsIpv6Addrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpv6Addrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationScope").getter(ConditionalForwarder.getter(ConditionalForwarder::replicationScopeAsString)).setter(ConditionalForwarder.setter(Builder::replicationScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_DOMAIN_NAME_FIELD, DNS_IP_ADDRS_FIELD, DNS_IPV6_ADDRS_FIELD, REPLICATION_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConditionalForwarder.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String remoteDomainName;
    private final List<String> dnsIpAddrs;
    private final List<String> dnsIpv6Addrs;
    private final String replicationScope;

    private ConditionalForwarder(BuilderImpl builder) {
        this.remoteDomainName = builder.remoteDomainName;
        this.dnsIpAddrs = builder.dnsIpAddrs;
        this.dnsIpv6Addrs = builder.dnsIpv6Addrs;
        this.replicationScope = builder.replicationScope;
    }

    public final String remoteDomainName() {
        return this.remoteDomainName;
    }

    public final boolean hasDnsIpAddrs() {
        return this.dnsIpAddrs != null && !(this.dnsIpAddrs instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddrs() {
        return this.dnsIpAddrs;
    }

    public final boolean hasDnsIpv6Addrs() {
        return this.dnsIpv6Addrs != null && !(this.dnsIpv6Addrs instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpv6Addrs() {
        return this.dnsIpv6Addrs;
    }

    public final ReplicationScope replicationScope() {
        return ReplicationScope.fromValue(this.replicationScope);
    }

    public final String replicationScopeAsString() {
        return this.replicationScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpv6Addrs() ? this.dnsIpv6Addrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalForwarder)) {
            return false;
        }
        ConditionalForwarder other = (ConditionalForwarder)obj;
        return Objects.equals(this.remoteDomainName(), other.remoteDomainName()) && this.hasDnsIpAddrs() == other.hasDnsIpAddrs() && Objects.equals(this.dnsIpAddrs(), other.dnsIpAddrs()) && this.hasDnsIpv6Addrs() == other.hasDnsIpv6Addrs() && Objects.equals(this.dnsIpv6Addrs(), other.dnsIpv6Addrs()) && Objects.equals(this.replicationScopeAsString(), other.replicationScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionalForwarder").add("RemoteDomainName", (Object)this.remoteDomainName()).add("DnsIpAddrs", this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null).add("DnsIpv6Addrs", this.hasDnsIpv6Addrs() ? this.dnsIpv6Addrs() : null).add("ReplicationScope", (Object)this.replicationScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemoteDomainName": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainName()));
            }
            case "DnsIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddrs()));
            }
            case "DnsIpv6Addrs": {
                return Optional.ofNullable(clazz.cast(this.dnsIpv6Addrs()));
            }
            case "ReplicationScope": {
                return Optional.ofNullable(clazz.cast(this.replicationScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RemoteDomainName", REMOTE_DOMAIN_NAME_FIELD);
        map.put("DnsIpAddrs", DNS_IP_ADDRS_FIELD);
        map.put("DnsIpv6Addrs", DNS_IPV6_ADDRS_FIELD);
        map.put("ReplicationScope", REPLICATION_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalForwarder, T> g) {
        return obj -> g.apply((ConditionalForwarder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String remoteDomainName;
        private List<String> dnsIpAddrs = DefaultSdkAutoConstructList.getInstance();
        private List<String> dnsIpv6Addrs = DefaultSdkAutoConstructList.getInstance();
        private String replicationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalForwarder model) {
            this.remoteDomainName(model.remoteDomainName);
            this.dnsIpAddrs(model.dnsIpAddrs);
            this.dnsIpv6Addrs(model.dnsIpv6Addrs);
            this.replicationScope(model.replicationScope);
        }

        public final String getRemoteDomainName() {
            return this.remoteDomainName;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        @Override
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final Collection<String> getDnsIpAddrs() {
            if (this.dnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddrs;
        }

        public final void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
        }

        @Override
        public final Builder dnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddrs(String ... dnsIpAddrs) {
            this.dnsIpAddrs(Arrays.asList(dnsIpAddrs));
            return this;
        }

        public final Collection<String> getDnsIpv6Addrs() {
            if (this.dnsIpv6Addrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpv6Addrs;
        }

        public final void setDnsIpv6Addrs(Collection<String> dnsIpv6Addrs) {
            this.dnsIpv6Addrs = DnsIpv6AddrsCopier.copy(dnsIpv6Addrs);
        }

        @Override
        public final Builder dnsIpv6Addrs(Collection<String> dnsIpv6Addrs) {
            this.dnsIpv6Addrs = DnsIpv6AddrsCopier.copy(dnsIpv6Addrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpv6Addrs(String ... dnsIpv6Addrs) {
            this.dnsIpv6Addrs(Arrays.asList(dnsIpv6Addrs));
            return this;
        }

        public final String getReplicationScope() {
            return this.replicationScope;
        }

        public final void setReplicationScope(String replicationScope) {
            this.replicationScope = replicationScope;
        }

        @Override
        public final Builder replicationScope(String replicationScope) {
            this.replicationScope = replicationScope;
            return this;
        }

        @Override
        public final Builder replicationScope(ReplicationScope replicationScope) {
            this.replicationScope(replicationScope == null ? null : replicationScope.toString());
            return this;
        }

        public ConditionalForwarder build() {
            return new ConditionalForwarder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionalForwarder> {
        public Builder remoteDomainName(String var1);

        public Builder dnsIpAddrs(Collection<String> var1);

        public Builder dnsIpAddrs(String ... var1);

        public Builder dnsIpv6Addrs(Collection<String> var1);

        public Builder dnsIpv6Addrs(String ... var1);

        public Builder replicationScope(String var1);

        public Builder replicationScope(ReplicationScope var1);
    }
}

