/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AssessmentValidation;
import software.amazon.awssdk.services.directory.model.AssessmentValidationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentReport> {
    private static final SdkField<String> DOMAIN_CONTROLLER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainControllerIp").getter(AssessmentReport.getter(AssessmentReport::domainControllerIp)).setter(AssessmentReport.setter(Builder::domainControllerIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllerIp").build()}).build();
    private static final SdkField<List<AssessmentValidation>> VALIDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Validations").getter(AssessmentReport.getter(AssessmentReport::validations)).setter(AssessmentReport.setter(Builder::validations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONTROLLER_IP_FIELD, VALIDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssessmentReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainControllerIp;
    private final List<AssessmentValidation> validations;

    private AssessmentReport(BuilderImpl builder) {
        this.domainControllerIp = builder.domainControllerIp;
        this.validations = builder.validations;
    }

    public final String domainControllerIp() {
        return this.domainControllerIp;
    }

    public final boolean hasValidations() {
        return this.validations != null && !(this.validations instanceof SdkAutoConstructList);
    }

    public final List<AssessmentValidation> validations() {
        return this.validations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainControllerIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidations() ? this.validations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentReport)) {
            return false;
        }
        AssessmentReport other = (AssessmentReport)obj;
        return Objects.equals(this.domainControllerIp(), other.domainControllerIp()) && this.hasValidations() == other.hasValidations() && Objects.equals(this.validations(), other.validations());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentReport").add("DomainControllerIp", (Object)this.domainControllerIp()).add("Validations", this.hasValidations() ? this.validations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainControllerIp": {
                return Optional.ofNullable(clazz.cast(this.domainControllerIp()));
            }
            case "Validations": {
                return Optional.ofNullable(clazz.cast(this.validations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainControllerIp", DOMAIN_CONTROLLER_IP_FIELD);
        map.put("Validations", VALIDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentReport, T> g) {
        return obj -> g.apply((AssessmentReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainControllerIp;
        private List<AssessmentValidation> validations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentReport model) {
            this.domainControllerIp(model.domainControllerIp);
            this.validations(model.validations);
        }

        public final String getDomainControllerIp() {
            return this.domainControllerIp;
        }

        public final void setDomainControllerIp(String domainControllerIp) {
            this.domainControllerIp = domainControllerIp;
        }

        @Override
        public final Builder domainControllerIp(String domainControllerIp) {
            this.domainControllerIp = domainControllerIp;
            return this;
        }

        public final List<AssessmentValidation.Builder> getValidations() {
            List<AssessmentValidation.Builder> result = AssessmentValidationsCopier.copyToBuilder(this.validations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidations(Collection<AssessmentValidation.BuilderImpl> validations) {
            this.validations = AssessmentValidationsCopier.copyFromBuilder(validations);
        }

        @Override
        public final Builder validations(Collection<AssessmentValidation> validations) {
            this.validations = AssessmentValidationsCopier.copy(validations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(AssessmentValidation ... validations) {
            this.validations(Arrays.asList(validations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(Consumer<AssessmentValidation.Builder> ... validations) {
            this.validations(Stream.of(validations).map(c -> (AssessmentValidation)((AssessmentValidation.Builder)AssessmentValidation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssessmentReport build() {
            return new AssessmentReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentReport> {
        public Builder domainControllerIp(String var1);

        public Builder validations(Collection<AssessmentValidation> var1);

        public Builder validations(AssessmentValidation ... var1);

        public Builder validations(Consumer<AssessmentValidation.Builder> ... var1);
    }
}

