/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AssessmentInstanceIdsCopier;
import software.amazon.awssdk.services.directory.model.CustomerDnsIpsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryVpcSettings;
import software.amazon.awssdk.services.directory.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentConfiguration> {
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerDnsIps").getter(AssessmentConfiguration.getter(AssessmentConfiguration::customerDnsIps)).setter(AssessmentConfiguration.setter(Builder::customerDnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(AssessmentConfiguration.getter(AssessmentConfiguration::dnsName)).setter(AssessmentConfiguration.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcSettings").getter(AssessmentConfiguration.getter(AssessmentConfiguration::vpcSettings)).setter(AssessmentConfiguration.setter(Builder::vpcSettings)).constructor(DirectoryVpcSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(AssessmentConfiguration.getter(AssessmentConfiguration::instanceIds)).setter(AssessmentConfiguration.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(AssessmentConfiguration.getter(AssessmentConfiguration::securityGroupIds)).setter(AssessmentConfiguration.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_DNS_IPS_FIELD, DNS_NAME_FIELD, VPC_SETTINGS_FIELD, INSTANCE_IDS_FIELD, SECURITY_GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssessmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> customerDnsIps;
    private final String dnsName;
    private final DirectoryVpcSettings vpcSettings;
    private final List<String> instanceIds;
    private final List<String> securityGroupIds;

    private AssessmentConfiguration(BuilderImpl builder) {
        this.customerDnsIps = builder.customerDnsIps;
        this.dnsName = builder.dnsName;
        this.vpcSettings = builder.vpcSettings;
        this.instanceIds = builder.instanceIds;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public final boolean hasCustomerDnsIps() {
        return this.customerDnsIps != null && !(this.customerDnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> customerDnsIps() {
        return this.customerDnsIps;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final DirectoryVpcSettings vpcSettings() {
        return this.vpcSettings;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerDnsIps() ? this.customerDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentConfiguration)) {
            return false;
        }
        AssessmentConfiguration other = (AssessmentConfiguration)obj;
        return this.hasCustomerDnsIps() == other.hasCustomerDnsIps() && Objects.equals(this.customerDnsIps(), other.customerDnsIps()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.vpcSettings(), other.vpcSettings()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentConfiguration").add("CustomerDnsIps", this.hasCustomerDnsIps() ? this.customerDnsIps() : null).add("DnsName", (Object)this.dnsName()).add("VpcSettings", (Object)this.vpcSettings()).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerDnsIps": {
                return Optional.ofNullable(clazz.cast(this.customerDnsIps()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "VpcSettings": {
                return Optional.ofNullable(clazz.cast(this.vpcSettings()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomerDnsIps", CUSTOMER_DNS_IPS_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("VpcSettings", VPC_SETTINGS_FIELD);
        map.put("InstanceIds", INSTANCE_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentConfiguration, T> g) {
        return obj -> g.apply((AssessmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> customerDnsIps = DefaultSdkAutoConstructList.getInstance();
        private String dnsName;
        private DirectoryVpcSettings vpcSettings;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentConfiguration model) {
            this.customerDnsIps(model.customerDnsIps);
            this.dnsName(model.dnsName);
            this.vpcSettings(model.vpcSettings);
            this.instanceIds(model.instanceIds);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final Collection<String> getCustomerDnsIps() {
            if (this.customerDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerDnsIps;
        }

        public final void setCustomerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
        }

        @Override
        public final Builder customerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIps(String ... customerDnsIps) {
            this.customerDnsIps(Arrays.asList(customerDnsIps));
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return this.vpcSettings != null ? this.vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = AssessmentInstanceIdsCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = AssessmentInstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public AssessmentConfiguration build() {
            return new AssessmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentConfiguration> {
        public Builder customerDnsIps(Collection<String> var1);

        public Builder customerDnsIps(String ... var1);

        public Builder dnsName(String var1);

        public Builder vpcSettings(DirectoryVpcSettings var1);

        default public Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return this.vpcSettings((DirectoryVpcSettings)((DirectoryVpcSettings.Builder)DirectoryVpcSettings.builder().applyMutation(vpcSettings)).build());
        }

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

