/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrustRequest extends DirectoryRequest implements
        ToCopyableBuilder<UpdateTrustRequest.Builder, UpdateTrustRequest> {
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustId").getter(getter(UpdateTrustRequest::trustId)).setter(setter(Builder::trustId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()).build();

    private static final SdkField<String> SELECTIVE_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectiveAuth").getter(getter(UpdateTrustRequest::selectiveAuthAsString))
            .setter(setter(Builder::selectiveAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectiveAuth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ID_FIELD,
            SELECTIVE_AUTH_FIELD));

    private final String trustId;

    private final String selectiveAuth;

    private UpdateTrustRequest(BuilderImpl builder) {
        super(builder);
        this.trustId = builder.trustId;
        this.selectiveAuth = builder.selectiveAuth;
    }

    /**
     * <p>
     * Identifier of the trust relationship.
     * </p>
     * 
     * @return Identifier of the trust relationship.
     */
    public final String trustId() {
        return trustId;
    }

    /**
     * <p>
     * Updates selective authentication for the trust.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectiveAuth}
     * will return {@link SelectiveAuth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectiveAuthAsString}.
     * </p>
     * 
     * @return Updates selective authentication for the trust.
     * @see SelectiveAuth
     */
    public final SelectiveAuth selectiveAuth() {
        return SelectiveAuth.fromValue(selectiveAuth);
    }

    /**
     * <p>
     * Updates selective authentication for the trust.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectiveAuth}
     * will return {@link SelectiveAuth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectiveAuthAsString}.
     * </p>
     * 
     * @return Updates selective authentication for the trust.
     * @see SelectiveAuth
     */
    public final String selectiveAuthAsString() {
        return selectiveAuth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustId());
        hashCode = 31 * hashCode + Objects.hashCode(selectiveAuthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustRequest)) {
            return false;
        }
        UpdateTrustRequest other = (UpdateTrustRequest) obj;
        return Objects.equals(trustId(), other.trustId())
                && Objects.equals(selectiveAuthAsString(), other.selectiveAuthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrustRequest").add("TrustId", trustId()).add("SelectiveAuth", selectiveAuthAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustId":
            return Optional.ofNullable(clazz.cast(trustId()));
        case "SelectiveAuth":
            return Optional.ofNullable(clazz.cast(selectiveAuthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustRequest, T> g) {
        return obj -> g.apply((UpdateTrustRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrustRequest> {
        /**
         * <p>
         * Identifier of the trust relationship.
         * </p>
         * 
         * @param trustId
         *        Identifier of the trust relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustId(String trustId);

        /**
         * <p>
         * Updates selective authentication for the trust.
         * </p>
         * 
         * @param selectiveAuth
         *        Updates selective authentication for the trust.
         * @see SelectiveAuth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectiveAuth
         */
        Builder selectiveAuth(String selectiveAuth);

        /**
         * <p>
         * Updates selective authentication for the trust.
         * </p>
         * 
         * @param selectiveAuth
         *        Updates selective authentication for the trust.
         * @see SelectiveAuth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectiveAuth
         */
        Builder selectiveAuth(SelectiveAuth selectiveAuth);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String trustId;

        private String selectiveAuth;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustRequest model) {
            super(model);
            trustId(model.trustId);
            selectiveAuth(model.selectiveAuth);
        }

        public final String getTrustId() {
            return trustId;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        @Transient
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final String getSelectiveAuth() {
            return selectiveAuth;
        }

        public final void setSelectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
        }

        @Override
        @Transient
        public final Builder selectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
            return this;
        }

        @Override
        @Transient
        public final Builder selectiveAuth(SelectiveAuth selectiveAuth) {
            this.selectiveAuth(selectiveAuth == null ? null : selectiveAuth.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustRequest build() {
            return new UpdateTrustRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
