/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNumberOfDomainControllersRequest extends DirectoryRequest implements
        ToCopyableBuilder<UpdateNumberOfDomainControllersRequest.Builder, UpdateNumberOfDomainControllersRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(UpdateNumberOfDomainControllersRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<Integer> DESIRED_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredNumber").getter(getter(UpdateNumberOfDomainControllersRequest::desiredNumber))
            .setter(setter(Builder::desiredNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            DESIRED_NUMBER_FIELD));

    private final String directoryId;

    private final Integer desiredNumber;

    private UpdateNumberOfDomainControllersRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.desiredNumber = builder.desiredNumber;
    }

    /**
     * <p>
     * Identifier of the directory to which the domain controllers will be added or removed.
     * </p>
     * 
     * @return Identifier of the directory to which the domain controllers will be added or removed.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The number of domain controllers desired in the directory.
     * </p>
     * 
     * @return The number of domain controllers desired in the directory.
     */
    public final Integer desiredNumber() {
        return desiredNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(desiredNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNumberOfDomainControllersRequest)) {
            return false;
        }
        UpdateNumberOfDomainControllersRequest other = (UpdateNumberOfDomainControllersRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(desiredNumber(), other.desiredNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNumberOfDomainControllersRequest").add("DirectoryId", directoryId())
                .add("DesiredNumber", desiredNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "DesiredNumber":
            return Optional.ofNullable(clazz.cast(desiredNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNumberOfDomainControllersRequest, T> g) {
        return obj -> g.apply((UpdateNumberOfDomainControllersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateNumberOfDomainControllersRequest> {
        /**
         * <p>
         * Identifier of the directory to which the domain controllers will be added or removed.
         * </p>
         * 
         * @param directoryId
         *        Identifier of the directory to which the domain controllers will be added or removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The number of domain controllers desired in the directory.
         * </p>
         * 
         * @param desiredNumber
         *        The number of domain controllers desired in the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredNumber(Integer desiredNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private Integer desiredNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNumberOfDomainControllersRequest model) {
            super(model);
            directoryId(model.directoryId);
            desiredNumber(model.desiredNumber);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        @Transient
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Integer getDesiredNumber() {
            return desiredNumber;
        }

        public final void setDesiredNumber(Integer desiredNumber) {
            this.desiredNumber = desiredNumber;
        }

        @Override
        @Transient
        public final Builder desiredNumber(Integer desiredNumber) {
            this.desiredNumber = desiredNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNumberOfDomainControllersRequest build() {
            return new UpdateNumberOfDomainControllersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
