/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains manual snapshot limit information for a directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotLimits implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotLimits.Builder, SnapshotLimits> {
    private static final SdkField<Integer> MANUAL_SNAPSHOTS_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotsLimit").getter(getter(SnapshotLimits::manualSnapshotsLimit))
            .setter(setter(Builder::manualSnapshotsLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotsLimit").build())
            .build();

    private static final SdkField<Integer> MANUAL_SNAPSHOTS_CURRENT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotsCurrentCount")
            .getter(getter(SnapshotLimits::manualSnapshotsCurrentCount))
            .setter(setter(Builder::manualSnapshotsCurrentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotsCurrentCount")
                    .build()).build();

    private static final SdkField<Boolean> MANUAL_SNAPSHOTS_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManualSnapshotsLimitReached")
            .getter(getter(SnapshotLimits::manualSnapshotsLimitReached))
            .setter(setter(Builder::manualSnapshotsLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotsLimitReached")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANUAL_SNAPSHOTS_LIMIT_FIELD,
            MANUAL_SNAPSHOTS_CURRENT_COUNT_FIELD, MANUAL_SNAPSHOTS_LIMIT_REACHED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer manualSnapshotsLimit;

    private final Integer manualSnapshotsCurrentCount;

    private final Boolean manualSnapshotsLimitReached;

    private SnapshotLimits(BuilderImpl builder) {
        this.manualSnapshotsLimit = builder.manualSnapshotsLimit;
        this.manualSnapshotsCurrentCount = builder.manualSnapshotsCurrentCount;
        this.manualSnapshotsLimitReached = builder.manualSnapshotsLimitReached;
    }

    /**
     * <p>
     * The maximum number of manual snapshots allowed.
     * </p>
     * 
     * @return The maximum number of manual snapshots allowed.
     */
    public final Integer manualSnapshotsLimit() {
        return manualSnapshotsLimit;
    }

    /**
     * <p>
     * The current number of manual snapshots of the directory.
     * </p>
     * 
     * @return The current number of manual snapshots of the directory.
     */
    public final Integer manualSnapshotsCurrentCount() {
        return manualSnapshotsCurrentCount;
    }

    /**
     * <p>
     * Indicates if the manual snapshot limit has been reached.
     * </p>
     * 
     * @return Indicates if the manual snapshot limit has been reached.
     */
    public final Boolean manualSnapshotsLimitReached() {
        return manualSnapshotsLimitReached;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotsCurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotsLimitReached());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotLimits)) {
            return false;
        }
        SnapshotLimits other = (SnapshotLimits) obj;
        return Objects.equals(manualSnapshotsLimit(), other.manualSnapshotsLimit())
                && Objects.equals(manualSnapshotsCurrentCount(), other.manualSnapshotsCurrentCount())
                && Objects.equals(manualSnapshotsLimitReached(), other.manualSnapshotsLimitReached());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotLimits").add("ManualSnapshotsLimit", manualSnapshotsLimit())
                .add("ManualSnapshotsCurrentCount", manualSnapshotsCurrentCount())
                .add("ManualSnapshotsLimitReached", manualSnapshotsLimitReached()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManualSnapshotsLimit":
            return Optional.ofNullable(clazz.cast(manualSnapshotsLimit()));
        case "ManualSnapshotsCurrentCount":
            return Optional.ofNullable(clazz.cast(manualSnapshotsCurrentCount()));
        case "ManualSnapshotsLimitReached":
            return Optional.ofNullable(clazz.cast(manualSnapshotsLimitReached()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotLimits, T> g) {
        return obj -> g.apply((SnapshotLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotLimits> {
        /**
         * <p>
         * The maximum number of manual snapshots allowed.
         * </p>
         * 
         * @param manualSnapshotsLimit
         *        The maximum number of manual snapshots allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotsLimit(Integer manualSnapshotsLimit);

        /**
         * <p>
         * The current number of manual snapshots of the directory.
         * </p>
         * 
         * @param manualSnapshotsCurrentCount
         *        The current number of manual snapshots of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotsCurrentCount(Integer manualSnapshotsCurrentCount);

        /**
         * <p>
         * Indicates if the manual snapshot limit has been reached.
         * </p>
         * 
         * @param manualSnapshotsLimitReached
         *        Indicates if the manual snapshot limit has been reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotsLimitReached(Boolean manualSnapshotsLimitReached);
    }

    static final class BuilderImpl implements Builder {
        private Integer manualSnapshotsLimit;

        private Integer manualSnapshotsCurrentCount;

        private Boolean manualSnapshotsLimitReached;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotLimits model) {
            manualSnapshotsLimit(model.manualSnapshotsLimit);
            manualSnapshotsCurrentCount(model.manualSnapshotsCurrentCount);
            manualSnapshotsLimitReached(model.manualSnapshotsLimitReached);
        }

        public final Integer getManualSnapshotsLimit() {
            return manualSnapshotsLimit;
        }

        public final void setManualSnapshotsLimit(Integer manualSnapshotsLimit) {
            this.manualSnapshotsLimit = manualSnapshotsLimit;
        }

        @Override
        @Transient
        public final Builder manualSnapshotsLimit(Integer manualSnapshotsLimit) {
            this.manualSnapshotsLimit = manualSnapshotsLimit;
            return this;
        }

        public final Integer getManualSnapshotsCurrentCount() {
            return manualSnapshotsCurrentCount;
        }

        public final void setManualSnapshotsCurrentCount(Integer manualSnapshotsCurrentCount) {
            this.manualSnapshotsCurrentCount = manualSnapshotsCurrentCount;
        }

        @Override
        @Transient
        public final Builder manualSnapshotsCurrentCount(Integer manualSnapshotsCurrentCount) {
            this.manualSnapshotsCurrentCount = manualSnapshotsCurrentCount;
            return this;
        }

        public final Boolean getManualSnapshotsLimitReached() {
            return manualSnapshotsLimitReached;
        }

        public final void setManualSnapshotsLimitReached(Boolean manualSnapshotsLimitReached) {
            this.manualSnapshotsLimitReached = manualSnapshotsLimitReached;
        }

        @Override
        @Transient
        public final Builder manualSnapshotsLimitReached(Boolean manualSnapshotsLimitReached) {
            this.manualSnapshotsLimitReached = manualSnapshotsLimitReached;
            return this;
        }

        @Override
        public SnapshotLimits build() {
            return new SnapshotLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
