/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveIpRoutesRequest extends DirectoryRequest implements
        ToCopyableBuilder<RemoveIpRoutesRequest.Builder, RemoveIpRoutesRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(RemoveIpRoutesRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> CIDR_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrIps")
            .getter(getter(RemoveIpRoutesRequest::cidrIps))
            .setter(setter(Builder::cidrIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            CIDR_IPS_FIELD));

    private final String directoryId;

    private final List<String> cidrIps;

    private RemoveIpRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.cidrIps = builder.cidrIps;
    }

    /**
     * <p>
     * Identifier (ID) of the directory from which you want to remove the IP addresses.
     * </p>
     * 
     * @return Identifier (ID) of the directory from which you want to remove the IP addresses.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCidrIps() {
        return cidrIps != null && !(cidrIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IP address blocks that you want to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrIps} method.
     * </p>
     * 
     * @return IP address blocks that you want to remove.
     */
    public final List<String> cidrIps() {
        return cidrIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrIps() ? cidrIps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveIpRoutesRequest)) {
            return false;
        }
        RemoveIpRoutesRequest other = (RemoveIpRoutesRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasCidrIps() == other.hasCidrIps()
                && Objects.equals(cidrIps(), other.cidrIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveIpRoutesRequest").add("DirectoryId", directoryId())
                .add("CidrIps", hasCidrIps() ? cidrIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "CidrIps":
            return Optional.ofNullable(clazz.cast(cidrIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveIpRoutesRequest, T> g) {
        return obj -> g.apply((RemoveIpRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveIpRoutesRequest> {
        /**
         * <p>
         * Identifier (ID) of the directory from which you want to remove the IP addresses.
         * </p>
         * 
         * @param directoryId
         *        Identifier (ID) of the directory from which you want to remove the IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * IP address blocks that you want to remove.
         * </p>
         * 
         * @param cidrIps
         *        IP address blocks that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIps(Collection<String> cidrIps);

        /**
         * <p>
         * IP address blocks that you want to remove.
         * </p>
         * 
         * @param cidrIps
         *        IP address blocks that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIps(String... cidrIps);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> cidrIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveIpRoutesRequest model) {
            super(model);
            directoryId(model.directoryId);
            cidrIps(model.cidrIps);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        @Transient
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getCidrIps() {
            if (cidrIps instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrIps;
        }

        public final void setCidrIps(Collection<String> cidrIps) {
            this.cidrIps = CidrIpsCopier.copy(cidrIps);
        }

        @Override
        @Transient
        public final Builder cidrIps(Collection<String> cidrIps) {
            this.cidrIps = CidrIpsCopier.copy(cidrIps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cidrIps(String... cidrIps) {
            cidrIps(Arrays.asList(cidrIps));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveIpRoutesRequest build() {
            return new RemoveIpRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
