/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainControllersRequest extends DirectoryRequest implements
        ToCopyableBuilder<DescribeDomainControllersRequest.Builder, DescribeDomainControllersRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeDomainControllersRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> DOMAIN_CONTROLLER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainControllerIds")
            .getter(getter(DescribeDomainControllersRequest::domainControllerIds))
            .setter(setter(Builder::domainControllerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDomainControllersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeDomainControllersRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            DOMAIN_CONTROLLER_IDS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private final String directoryId;

    private final List<String> domainControllerIds;

    private final String nextToken;

    private final Integer limit;

    private DescribeDomainControllersRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.domainControllerIds = builder.domainControllerIds;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * Identifier of the directory for which to retrieve the domain controller information.
     * </p>
     * 
     * @return Identifier of the directory for which to retrieve the domain controller information.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainControllerIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainControllerIds() {
        return domainControllerIds != null && !(domainControllerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers for the domain controllers whose information will be provided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainControllerIds} method.
     * </p>
     * 
     * @return A list of identifiers for the domain controllers whose information will be provided.
     */
    public final List<String> domainControllerIds() {
        return domainControllerIds;
    }

    /**
     * <p>
     * The <i>DescribeDomainControllers.NextToken</i> value from a previous call to <a>DescribeDomainControllers</a>.
     * Pass null if this is the first call.
     * </p>
     * 
     * @return The <i>DescribeDomainControllers.NextToken</i> value from a previous call to
     *         <a>DescribeDomainControllers</a>. Pass null if this is the first call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return.
     * </p>
     * 
     * @return The maximum number of items to return.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainControllerIds() ? domainControllerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainControllersRequest)) {
            return false;
        }
        DescribeDomainControllersRequest other = (DescribeDomainControllersRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasDomainControllerIds() == other.hasDomainControllerIds()
                && Objects.equals(domainControllerIds(), other.domainControllerIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainControllersRequest").add("DirectoryId", directoryId())
                .add("DomainControllerIds", hasDomainControllerIds() ? domainControllerIds() : null)
                .add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "DomainControllerIds":
            return Optional.ofNullable(clazz.cast(domainControllerIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainControllersRequest, T> g) {
        return obj -> g.apply((DescribeDomainControllersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDomainControllersRequest> {
        /**
         * <p>
         * Identifier of the directory for which to retrieve the domain controller information.
         * </p>
         * 
         * @param directoryId
         *        Identifier of the directory for which to retrieve the domain controller information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * A list of identifiers for the domain controllers whose information will be provided.
         * </p>
         * 
         * @param domainControllerIds
         *        A list of identifiers for the domain controllers whose information will be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllerIds(Collection<String> domainControllerIds);

        /**
         * <p>
         * A list of identifiers for the domain controllers whose information will be provided.
         * </p>
         * 
         * @param domainControllerIds
         *        A list of identifiers for the domain controllers whose information will be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllerIds(String... domainControllerIds);

        /**
         * <p>
         * The <i>DescribeDomainControllers.NextToken</i> value from a previous call to
         * <a>DescribeDomainControllers</a>. Pass null if this is the first call.
         * </p>
         * 
         * @param nextToken
         *        The <i>DescribeDomainControllers.NextToken</i> value from a previous call to
         *        <a>DescribeDomainControllers</a>. Pass null if this is the first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> domainControllerIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainControllersRequest model) {
            super(model);
            directoryId(model.directoryId);
            domainControllerIds(model.domainControllerIds);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        @Transient
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getDomainControllerIds() {
            if (domainControllerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return domainControllerIds;
        }

        public final void setDomainControllerIds(Collection<String> domainControllerIds) {
            this.domainControllerIds = DomainControllerIdsCopier.copy(domainControllerIds);
        }

        @Override
        @Transient
        public final Builder domainControllerIds(Collection<String> domainControllerIds) {
            this.domainControllerIds = DomainControllerIdsCopier.copy(domainControllerIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainControllerIds(String... domainControllerIds) {
            domainControllerIds(Arrays.asList(domainControllerIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDomainControllersRequest build() {
            return new DescribeDomainControllersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
